package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestModifyShelfState extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifyShelfState")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "停用会员卡")
    public void testmodifyShelfState() {
        CardTools Cardtools = new CardTools();
        Cardtools.fetchPageOfMemberCard();

        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");


        JSONObject jsonObject = new JSONObject();

        jsonObject.put("shelfState","NO");
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "启用会员卡")
    public void testmodifyShelfState1() {
        CardTools Cardtools = new CardTools();
        Cardtools.fetchPageOfMemberCard();

        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");


        JSONObject jsonObject = new JSONObject();

        jsonObject.put("shelfState","YES");
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }

}
