package com.xiaomai.cases.polar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.reserve.personal
 * @Author: xuyamei
 * @CreateTime: 2024-07-24  10:05
 * @Description: 修改特定可约时间
 * @Version: 1.0
 */
public class TestModifySpecialDate extends BaseTestImpl {
    @Resource(name = "reserveTools")
    ReserveTools reserveTools;
    private String id;
    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Reserve, "API_modifySpecialDate", LoginAccount.GYM_PROD, Terminal.B, "xym");
        super.beforeTest();
    }


    @Test
    public void testModifySpecialDate(){
        Long date = TimeUtils.getTodayTime();

        // 先创建特殊可约时间，当天可休息
        reserveTools.createSpecialDate(xmAppApi.getLoginInfo().getAdminId(),"OFF_DUTY",new JSONObject());

        // 可约时间段
        JSONArray timePeriodInfos = new JSONArray();
        JSONObject timePeriodInfo = new JSONObject();
        timePeriodInfo.put("minuteOffset", 0);
        timePeriodInfo.put("spanMinutes", 720);
        timePeriodInfos.add(timePeriodInfo);
        // 修改特殊可约时间
        reserveTools.modifySpecialDate(xmAppApi.getLoginInfo().getAdminId(),"ON_DUTY",timePeriodInfos,date);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // 修改特殊可约时间后检查个人私教时间
        JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(xmAppApi.getLoginInfo().getAdminId(),"specialTimeVOS");
        boolean flag = false;
        for (int i = 0; i < specialTimeVOS.size(); i++){
            JSONObject specialTimeVO = specialTimeVOS.getJSONObject(i);
            if (date.toString().equals(specialTimeVO.getString("dutyDate"))){
                flag = true;
                id = specialTimeVO.getJSONArray("recordIds").getString(0);
                Assert.assertEquals(specialTimeVO.getString("dutyType"),"1","修改特殊日期类型后查询到全天休息");
                Assert.assertTrue(specialTimeVO.getString("timePeriodInfos").equals(timePeriodInfos.toString()),"修改特殊日期可约时间段与查询到的数据不一致");

            }
        }
        Assert.assertTrue(flag,"特殊日期不存在");

    }

    @Test(description = "清除数据",priority = 1)
    public void del(){
        reserveTools.deleteSpecialDate(id);
    }


}
