package com.xiaomai.cases.polar.training;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import lombok.Getter;
import org.testng.annotations.BeforeClass;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**创建训练营活动时构造参数
 * @author adu
 * data 2024/7/3 19:44
 */

@Getter
public class BaseCreateTrainingData extends BaseTestImpl {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    String applyStartTime = "";
    String applyEndTime = "";
    String openStartDate = "";
    String openEndDate = "";
    String openStartDate1 = "";
    String openEndDate1 = "";
    String courseName = "";
    String trainingTitle = "";
    List<String> trainerListIdS;
    List<String> editTrainerListId;
    String courseId = "";
    long currentTimestamp = System.currentTimeMillis();
    // 在当前时间的基础上，加上2秒（2000毫秒）
    long futureTimestamp = currentTimestamp + 5000;//晚于当前时间8秒
    String futureTimestampS=String.valueOf(futureTimestamp);


    @BeforeClass
    public void beforeTest() {
        super.beforeTest();
        applyStartTime = String.valueOf(CommUtil.getWholeHourTimestamp()); //当前时间的整点+1小时，比如现在是13：00，然后获取的是14：00的时间戳
        applyEndTime = CommUtil.oneKeyGetAddDay(1);//明天0点
        openStartDate = applyEndTime;
        openEndDate = CommUtil.getNDayEndTimeTamp(2);//后天23：59：59
        openStartDate1 = CommUtil.oneKeyGetAddDay(2);//后天0点
        openEndDate1 = CommUtil.getNDayEndTimeTamp(5);// 23：59：59
        courseName = "训练营课程-感统课";
        trainingTitle = "三期36天训练营感统课";
        courseTools.getTrainingCampCourseList(new ArrayList<>(), "ON", courseName);
        int n = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (n > 0) {
            courseId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].brandCourseId");
        }
        if (courseId == "") {
            //获取存量课程分类ID
            String categoryId = courseCategoryTools.getCourseCategoryPage("训练营");
            courseId = courseTools.createTrainingCampCourse(courseName, categoryId, "50", "#AACF53");
        }
        List<String> trainerList = new ArrayList<>();
        trainerList.add("木头");
        trainerList.add("吴彦祖");
        trainerList.add("杜君丽");
        trainerListIdS = groupScheduleTools.getStudioAdminId(trainerList);
        List<String> trainerListEdit = new ArrayList<>();
        trainerListEdit.add("杜君丽");
        editTrainerListId=groupScheduleTools.getStudioAdminId(trainerListEdit);

    }
}

    