package com.xiaomai.cases.polar.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author: xyy
 * @CreateTime: 2024-04-13  11:48
 * @Description: 批量修改场馆配置
 * @Version: 1.0
 */
public class TestBatchModifyStudioConfig extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Config)
                .setApiName("API_batchModifyStudioConfig")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "批量修改场馆配置")
    public void testBatchModifyStudioConfig(){

        JSONObject object = new JSONObject();
        //构建configListRequest
        JSONArray configListRequest = new JSONArray();
        JSONObject smsObject = new JSONObject();
        smsObject.put("msgType","SMS");
        smsObject.put("configValue","TRUE");
        JSONObject wechatObject = new JSONObject();
        wechatObject.put("msgType","WECHAT");
        wechatObject.put("configValue","TRUE");
        configListRequest.add(smsObject);
        configListRequest.add(wechatObject);

        //构建messageConfigTypes
        JSONArray messageConfigTypes = new JSONArray();
        messageConfigTypes.add("ALL");
        object.put("configListRequest",configListRequest);
        object.put("messageConfigTypes",messageConfigTypes);
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");
    }
}
