package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 查看训练营课次详情
 *
 * @author adu
 * data 2024/7/12 10:31
 */

public class TestGetCampScheduleItemDetail extends SelectTargetTrainingCampAndGetInfo {
    @Resource(name = "campScheduleTools")
    CampScheduleTools campScheduleTools;
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    @Resource(name = "tools")
    Tools tools;
    String campId = "";
    String chiefCoachId = "";
    String ruldId = "";
    String memberId = "";
    String orderId = "";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_getCampScheduleItemDetail", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "查看课次详情")
    public void testGetCampScheduleItemDetail() {
        //获取选择的训练营ID
        campId = super.campId;
        //获取训练营活动的指定教练ID
        chiefCoachId = super.chiefCoachId;

        //先报名训练营活动，再创建课次，创建课次后check 课次中有学员，自动生成预约记录

        //搜索目标会员
        String phone = "15558121569";
        memberId = trainingTools.searchTargerMember(phone);
        if (memberId.isEmpty()) {
            memberId = tools.create("阿杜", phone).getString("result");
        }
        //给会员报名
        trainingTools.doSignCampOrder(memberId, this.price, this.campId,"");
        orderId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result");
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        String memberCardId = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("memberCardId");


        //创建训练营排课：按次数 星期：2，4，6，7
        campScheduleTools.oneKeyCreateCampRuleSchedule(campId, chiefCoachId, super.courseId,
                super.traineeLowerLimit, super.traineeUpperLimit,
                "1140", super.openEndDate, true,
                "22");
        //查询排课日程:根据训练营和关联课程查询
        campScheduleTools.getCampRuleScheduleList(campId, super.courseId, "");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "排课创建成功后，日程中没查询到对应数据");
        ruldId = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("ruleId");

        //查看下周5的日课表，期望值无数据
        Set<String> scheduleIds5 = campScheduleTools.getCampTableDate(11,ruldId);
        Assert.assertTrue(scheduleIds5.size() == 0 || scheduleIds5 == null, "周五没排课，但是检查出有课次");

        //查看下周日的日课表，有数据，并查看课次详情
        String startDate = CommUtil.oneKeyGetNextWeekXDay(13);//下周日00点时间
        String endDate = CommUtil.oneKeyGetNextWeekEndXDay(7);//下周日23：59
        campScheduleTools.getCampScheduleTable(startDate, endDate);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups").size() >= 1, "下周日排的有课次，但是发现没课次");
        //过滤出刚创建的课次
        JSONArray array = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups");
        String scheduleId = array.toJavaList(JSONObject.class).stream()
                //.filter(e -> e.getString("date").equals(startDate))//过滤出日期等于下周日的数据
                .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())//对过滤出的数据再次取目标数据重新组合成一个新的数据流
                .filter(e -> e.getJSONObject("campVO").getString("id").equals(campId))
                .map(e -> e.getString("scheduleId"))//获取scheduleId
                .findFirst().orElse(null);

        //查看课次详情
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("id", scheduleId);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);

        //断言check
        //课次中有1个学员check
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(xmAppApi.getApi_response(), "$.result.memberReserveList").size() == 1, "排课前有学员报名了关联的训练营活动，所以课次中有1个预约学员，目前没发现课次中有学员");
        //主教练check
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.result.chiefCoachId"), chiefCoachId, "教练和创建时设置的不一致");
        //助教check
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(xmAppApi.getApi_response(), "$.result.assistCoachIds").isEmpty(), "创建排课时助教设置为空，但是课次详情中显示不为空哦");
        //场地check
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(xmAppApi.getApi_response(), "$.result.venueAreaIds").isEmpty(), "创建排课时场地设置为空，但是课次详情中显示不为空哦");

        //会员退款订单check
        trainingTools.refundCampOrder(memberId, this.price, memberCardId, this.totalClassHour);
        //退单后再次check课次详情
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        JSONArray memberReserveList = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.memberReserveList");
        Assert.assertTrue(memberReserveList == null || memberReserveList.size() == 0, "学员退单后，没有从课次中移除");



    }

    @AfterTest(description = "删除此case创建的训练营排课日程")
    public void delData() {

        if (null != orderId || !orderId.isEmpty()) {
            trainingTools.fetchUserTrainingCardList(memberId);
            if (!XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("state").equals("REFUNDED")) {
                orderTools.discard(orderId, "重复录入", "自动化测试作废训练营订单");
            }
        }
        if (null != campId || !campId.isEmpty()) {
            this.getTrainingTools().deleteTraining(campId);
        }

    }


}

    