package com.xiaomai.cases.polar.coupon;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

public class TestGetStudioCouponList extends BaseTestImpl {
    @Resource(name = "couponTools")
    CouponTools couponTools;

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Coupon, "API_getStudioCouponList", LoginAccount.ADU_PROD, Terminal.B, "yj");
        super.beforeTest();
    }

    @Test(description = "搜索对应的优惠券")
    public void testgetStudioCouponList() {
        List<String> memberStatusLimitsB=new ArrayList<>();
        memberStatusLimitsB.add("POTENTIAL");
        String couponName ="用于搜索的优惠券"+RandomStringUtil.randomString(3);

        couponTools.createCoupon("WITHOUT","WITHOUT",memberStatusLimitsB,couponName,false,
                "DISCOUNT", 2,"ABSOLUTE","搜索的优惠券备注");
        JSONObject body = new JSONObject();
        body.put("current", 0);
        body.put("size", 20);
        body.put("nameLike",couponName);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers).assetsSuccess(true);

        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response, "$.message"), "操作成功!");
        Assert.assertEquals(XMJSONPath.readPath(response, "$.result.records[0].name"), couponName);

        couponTools.getStudioCouponList(couponName,"CLAIMABLE");//搜索正常的优惠券
        String couponId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].id");//拿搜索的第一条唯一优惠券
        couponTools.InvalidCoupon(couponId);//失效优惠券
        couponTools.getStudioCouponList(couponName,"VOIDED");//搜索失效的优惠券
        Assert.assertEquals(XMJSONPath.readPath(response, "$.result.records[0].name"), couponName);//失效的优惠券

        couponTools.getCouponDetail(couponId);//优惠券详情
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.status").equals("VOIDED"),"操作失效优惠券后，查看优惠券详情，后端返回的状态值不是VOIDED");



    }
}
