package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 对报名中的活动操作立即成营
 *
 * @author adu
 * data 2024/7/3 17:53
 */

public class TestDoForceOpenTraining extends BaseCreateTrainingData {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    String id = "";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_forceOpenTraining", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }

    @Test(description = "测试对未开营的活动操作立即成营")
    public void testForceOpenTraining() throws InterruptedException {

        //1.创建训练营活动：保存并发布
        id = trainingTools.createThenPublishTraining(CommUtil.getTodayGoalTime(20), applyEndTime, courseId, openStartDate,
                openEndDate, 0.01, trainingTitle, 2, 1, trainerListIdS, "YES");
        if (id.isEmpty()) {
            id = trainingTools.createThenPublishTraining(CommUtil.getTodayGoalTime(20), applyEndTime, courseId, openStartDate,
                    openEndDate, 0.01, trainingTitle + RandomStringUtil.randomString(3), 2, 1, trainerListIdS, "YES");
        }
        //2.查看活动详情，check 活动状态
        trainingTools.findTrainingDetailById(id);
        String status = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state");
        //报名未开始APPLY_NOT_START
        if (status.equals("APPLY_NOT_START")) {
            //对报名未开始的活动操作立即成营
            JSONObject body = new JSONObject();
            body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            body.put("id", id);
            xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
            Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"), "只有报名中的训练营能【立即成营】");

        }

        //3.创建成功后，全局搜索check
        Thread.sleep(10000);
        trainingTools.commonSearchTraining(trainingTitle);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() > 0, "活动创建后，根据活动名称全局搜索没有数据");



        //4.对报名中的活动操作立即成营
        //搜索列表中有没有报名中APPLYING的训练营，如果有，就操作立即成营
        List<String> statuApplying = new ArrayList<>();
        statuApplying.add("APPLYING");//报名中
        trainingTools.searchTrainingList("","",statuApplying);
        String goalId="";
        int goalN= XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.records").size();
        if(goalN>0){
            goalId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].id");
            JSONObject body1 = new JSONObject();
            body1.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            body1.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            body1.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            body1.put("id", goalId);
            xmAppApi.doRequest(RequestType.JSON, params, body1.toString(), headers);
            Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));


        }


    }


    @AfterTest(description = "删除此case创建的训练营活动")
    public void delData() {
        if (!id.isEmpty()) {
            trainingTools.deleteTraining(id);
        }

    }
}

    