package com.xiaomai.cases.polar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.goods.GoodCTools;
import com.xiaomai.cases.polar.goods.Tools.GoodTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class createGoods extends XMBaseTest {

    GoodTools goodTools=new GoodTools();
    GoodCTools goodCTools=new GoodCTools();
    String studioResult1;
    String studioResult2;


    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_createGoods")
                .setLoginUser(LoginAccount.YFF_RC)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "创建物品-多规格")
    public void testCreateGoods() {


        //分组是存量的，因为只能创建10个，超了的话还是要用存量的

        //获取物品列表
        JSONObject beforeTotalStudioGoods= goodTools.studioGoods();
        int beforeTotal=Integer.parseInt(beforeTotalStudioGoods.getJSONObject("result").getString("total"));

//
//        //切换端位
//        DataUserInfo info = new DataUserInfo();
//        info.setTerminal(Terminal.C);
//        info.setLoginUser(LoginAccount.GYM_MINIAPPC);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


//        JSONObject beforePageXcxHomeGoods_C = goodCTools.pageXcxHomeGoods_C(info);
//        int beforeTotal_C = Integer.parseInt(beforePageXcxHomeGoods_C.getJSONObject("result").getString("total"));

        String name="自动化创建三个规格" + RandomStringUtil.randomString(2);

        //物品名称重名校验：为false才是不重名
        boolean checkRepeatNameForStudio=Boolean.parseBoolean(goodTools.checkRepeatNameForStudio(name).getString("result"));

        if(checkRepeatNameForStudio==false) {

            String color1 = "黑色";
            String color2 = "白色";
            String size1 = "大的";
            String size2 = "小的";
            String skin1 = "貂蝉";
            String skin2 = "王昭君";

            JSONObject jsonObject = new JSONObject();
            //商品介绍为空
            // JSONObject description=new JSONObject();
            // jsonObject.put("description",description.toString());

            //商品介绍不为空，纯文本
            JSONObject description = new JSONObject();
            JSONArray items = new JSONArray();
            JSONObject item1 = new JSONObject();
            item1.put("type", "TEXT");
            item1.put("content", "自动化创建的多规格三个规格，每个规格都有两个规格值");
            item1.put("aspect", "");

            items.add(item1);

            description.put("items", items);
            jsonObject.put("description", description.toString());


            jsonObject.put("groupId", "1869984687228407810");
            jsonObject.put("multiSpec", true);
            jsonObject.put("name", name);
            jsonObject.put("xcxSaleState", "YES");


            JSONObject multiSpecInfo = new JSONObject();

            //设置三个规格和每个都有两个规格值
            JSONArray specList = new JSONArray();
            JSONObject specList1 = new JSONObject();
            specList1.put("name", "颜色");

            JSONArray specList1SpecValues = new JSONArray();
            JSONObject specList1SpecValues1 = new JSONObject();
            specList1SpecValues1.put("name", color1);
            JSONObject specList1SpecValues2 = new JSONObject();
            specList1SpecValues2.put("name", color2);
            specList1SpecValues.add(specList1SpecValues1);
            specList1SpecValues.add(specList1SpecValues2);
            specList1.put("specValues", specList1SpecValues);

            JSONObject specList2 = new JSONObject();
            specList2.put("name", "尺码");

            JSONArray specList2SpecValues = new JSONArray();
            JSONObject specList2SpecValues1 = new JSONObject();
            specList2SpecValues1.put("name", size1);
            JSONObject specList2SpecValues2 = new JSONObject();
            specList2SpecValues2.put("name", size2);
            specList2SpecValues.add(specList2SpecValues1);
            specList2SpecValues.add(specList2SpecValues2);
            specList2.put("specValues", specList2SpecValues);


            JSONObject specList3 = new JSONObject();
            specList3.put("name", "限定皮肤");

            JSONArray specList3SpecValues = new JSONArray();
            JSONObject specList3SpecValues1 = new JSONObject();
            specList3SpecValues1.put("name", skin1);
            JSONObject specList3SpecValues2 = new JSONObject();
            specList3SpecValues2.put("name", skin2);
            specList3SpecValues.add(specList3SpecValues1);
            specList3SpecValues.add(specList3SpecValues2);
            specList3.put("specValues", specList3SpecValues);

            specList.add(specList1);
            specList.add(specList2);
            specList.add(specList3);

            multiSpecInfo.put("specList", specList);


            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //排列出来的组合2*2*2
            JSONArray specCombinationList = new JSONArray();

            JSONObject specCombinationList1 = new JSONObject();

            JSONArray specCombinationList1Specs = new JSONArray();
            specCombinationList1Specs.add(color1);
            specCombinationList1Specs.add(size1);
            specCombinationList1Specs.add(skin1);
            specCombinationList1.put("specs", specCombinationList1Specs);
            specCombinationList1.put("price", "0.01");
            specCombinationList1.put("inventory", 10);

            specCombinationList.add(specCombinationList1);

            JSONObject specCombinationList2 = new JSONObject();
            JSONArray specCombinationList2Specs = new JSONArray();
            specCombinationList2Specs.add(color1);
            specCombinationList2Specs.add(size1);
            specCombinationList2Specs.add(skin2);
            specCombinationList2.put("specs", specCombinationList2Specs);
            specCombinationList2.put("price", "0.01");
            specCombinationList2.put("inventory", 10);

            specCombinationList.add(specCombinationList2);


            JSONObject specCombinationList3 = new JSONObject();
            JSONArray specCombinationList3Specs = new JSONArray();
            specCombinationList3Specs.add(color1);
            specCombinationList3Specs.add(size2);
            specCombinationList3Specs.add(skin1);
            specCombinationList3.put("specs", specCombinationList3Specs);
            specCombinationList3.put("price", "0.01");
            specCombinationList3.put("inventory", 10);

            specCombinationList.add(specCombinationList3);


            JSONObject specCombinationList4 = new JSONObject();
            JSONArray specCombinationList4Specs = new JSONArray();
            specCombinationList4Specs.add(color1);
            specCombinationList4Specs.add(size2);
            specCombinationList4Specs.add(skin2);
            specCombinationList4.put("specs", specCombinationList4Specs);
            specCombinationList4.put("price", "0.01");
            specCombinationList4.put("inventory", 10);

            specCombinationList.add(specCombinationList4);


            JSONObject specCombinationList5 = new JSONObject();
            JSONArray specCombinationList5Specs = new JSONArray();
            specCombinationList5Specs.add(color2);
            specCombinationList5Specs.add(size1);
            specCombinationList5Specs.add(skin1);
            specCombinationList5.put("specs", specCombinationList5Specs);
            specCombinationList5.put("price", "0.01");
            specCombinationList5.put("inventory", 10);

            specCombinationList.add(specCombinationList5);


            JSONObject specCombinationList6 = new JSONObject();
            JSONArray specCombinationList6Specs = new JSONArray();
            specCombinationList6Specs.add(color2);
            specCombinationList6Specs.add(size1);
            specCombinationList6Specs.add(skin2);
            specCombinationList6.put("specs", specCombinationList6Specs);
            specCombinationList6.put("price", "0.01");
            specCombinationList6.put("inventory", 10);

            specCombinationList.add(specCombinationList6);

            JSONObject specCombinationList7 = new JSONObject();
            JSONArray specCombinationList7Specs = new JSONArray();
            specCombinationList7Specs.add(color2);
            specCombinationList7Specs.add(size2);
            specCombinationList7Specs.add(skin1);
            specCombinationList7.put("specs", specCombinationList7Specs);
            specCombinationList7.put("price", "0.01");
            specCombinationList7.put("inventory", 10);

            specCombinationList.add(specCombinationList7);


            JSONObject specCombinationList8 = new JSONObject();
            JSONArray specCombinationList8Specs = new JSONArray();
            specCombinationList8Specs.add(color2);
            specCombinationList8Specs.add(size2);
            specCombinationList8Specs.add(skin2);
            specCombinationList8.put("specs", specCombinationList8Specs);
            specCombinationList8.put("price", "0.01");
            specCombinationList8.put("inventory", 10);

            specCombinationList.add(specCombinationList8);

            multiSpecInfo.put("specCombinationList", specCombinationList);
            jsonObject.put("multiSpecInfo", multiSpecInfo);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
            JSONObject response = xmAppApi.getBodyInJSON();
            studioResult1 = response.getString("result");

            //校验：
            //校验1：获取B端物品列表
            //①统计值增加1
            //②有对应的商品id
            JSONObject afterStudioGoods = goodTools.studioGoods();
            int afterTotal = Integer.parseInt(afterStudioGoods.getJSONObject("result").getString("total"));
            JSONArray records = afterStudioGoods.getJSONObject("result").getJSONArray("records");

            boolean success=false;
            for (int i = 0; i < records.size(); i++) {
                if (records.getJSONObject(i).getString("id").equals(studioResult1)) {
                    success=true;
                }
                Assert.assertEquals(success, true, "新建三个规格的物品成功，但物品列表未找到对应增加的物品ID");
            }
            Assert.assertEquals(afterTotal, beforeTotal + 1, "新建三个规格的物品成功，但物品列表的统计值未增加");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

//            //校验：
//            //校验2：获取C端物品列表
//            //①统计值增加1
//            //②有对应的商品id
//            JSONObject afterPageXcxHomeGoods_C = goodCTools.pageXcxHomeGoods_C(info);
//            int afterTotal_C = Integer.parseInt(afterPageXcxHomeGoods_C.getJSONObject("result").getString("total"));
//            JSONArray records_C = afterPageXcxHomeGoods_C.getJSONObject("result").getJSONArray("records");
//
//            boolean success_C=false;
//            for (int i = 0; i < records_C.size(); i++) {
//                if (records_C.getJSONObject(i).getString("id").equals(studioResult1)) {
//                    success_C=true;
//                }
//                Assert.assertEquals(success_C, true, "新建三个规格的物品成功，但C端的物品列表未找到对应增加的物品ID");
//            }
//            Assert.assertEquals(afterTotal_C, beforeTotal_C + 1, "新建三个规格的物品成功，但C端物品列表的统计值未增加");


            //校验3：获取B端物品详情,状态是开启，小程序售卖也是开启
            JSONObject getDetail_goods=goodTools.getDetail_goods(studioResult1);
            String state=getDetail_goods.getJSONObject("result").getString("state");
            String xcxSaleState=getDetail_goods.getJSONObject("result").getString("xcxSaleState");
            //规格1ID
            String getDetailSpecListId1=getDetail_goods.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specList").getJSONObject(0).getString("id");
            //规格2ID
            String getDetailSpecListId2=getDetail_goods.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specList").getJSONObject(1).getString("id");
            //规格3ID
            String getDetailSpecListId3=getDetail_goods.getJSONObject("result").getJSONObject("multiSpecInfo").getJSONArray("specList").getJSONObject(2).getString("id");
            Assert.assertEquals(state,"YES","新建物品是启用，但物品详情展示非启用");
            Assert.assertEquals(xcxSaleState,"YES","新建物品是开启小程序售卖，但物品详情展示非开启小程序售卖");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
//
//            //校验4：获取C端物品详情,状态是开启，小程序售卖也是开启
//            JSONObject getDetail_goods_C=goodCTools.getDetail_goods_C(studioResult1,info);
//            String state_C=getDetail_goods_C.getJSONObject("result").getString("state");
//            String xcxSaleState_C=getDetail_goods_C.getJSONObject("result").getString("xcxSaleState");
//            Assert.assertEquals(state_C,"YES","新建物品是启用，但C端物品详情展示非启用");
//            Assert.assertEquals(xcxSaleState_C,"YES","新建物品是开启小程序售卖，但C端物品详情展示非开启小程序售卖");


            //校验5：获取B端查看多规格的库存详情，和物品详情的规格id都一致
            JSONObject listMultiSpecInventorRecords=goodTools.listMultiSpecInventorRecords(studioResult1);
            //规格1ID
            String listMultiSpecInventorRecordsSpecListId1=listMultiSpecInventorRecords.getJSONObject("result").getJSONArray("specList").getJSONObject(0).getString("id");
            //规格2ID
            String listMultiSpecInventorRecordsSpecListId2=listMultiSpecInventorRecords.getJSONObject("result").getJSONArray("specList").getJSONObject(1).getString("id");
            //规格3ID
            String listMultiSpecInventorRecordsSpecListId3=listMultiSpecInventorRecords.getJSONObject("result").getJSONArray("specList").getJSONObject(2).getString("id");

            Assert.assertTrue(listMultiSpecInventorRecordsSpecListId1.equals(getDetailSpecListId1),"新建物品的库存详情的规格1的规格ID和物品详情的规格1的规格ID不一致");
            Assert.assertTrue(listMultiSpecInventorRecordsSpecListId2.equals(getDetailSpecListId2),"新建物品的库存详情的规格2的规格ID和物品详情的规格2的规格ID不一致");
            Assert.assertTrue(listMultiSpecInventorRecordsSpecListId3.equals(getDetailSpecListId3),"新建物品的库存详情的规格3的规格ID和物品详情的规格3的规格ID不一致");


            try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

    @Test(description = "创建物品-单规格")
    public void testCreateGoods_1() {

        //获取物品列表
        JSONObject beforeTotalStudioGoods= goodTools.studioGoods();
        int beforeTotal=Integer.parseInt(beforeTotalStudioGoods.getJSONObject("result").getString("total"));


//        //切换端位
//        DataUserInfo info = new DataUserInfo();
//        info.setTerminal(Terminal.C);
//        info.setLoginUser(LoginAccount.GYM_MINIAPPC);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


//        JSONObject beforePageXcxHomeGoods_C = goodCTools.pageXcxHomeGoods_C(info);
//        int beforeTotal_C = Integer.parseInt(beforePageXcxHomeGoods_C.getJSONObject("result").getString("total"));

        String name = "自动化创建单规格" + RandomStringUtil.randomString(2);

        //物品名称重名校验：为false才是不重名
        boolean checkRepeatNameForStudio = Boolean.parseBoolean(goodTools.checkRepeatNameForStudio(name).getString("result"));

        if (checkRepeatNameForStudio == false) {
            //单规格
            JSONObject jsonObject = new JSONObject();
            //商品介绍不为空，纯文本
            JSONObject description = new JSONObject();
            JSONArray items = new JSONArray();
            JSONObject item1 = new JSONObject();
            item1.put("type", "TEXT");
            item1.put("content", "自动化创建的");
            item1.put("aspect", "");

            items.add(item1);

            description.put("items", items);
            jsonObject.put("description", description.toString());

            jsonObject.put("groupId", "1869984687228407810");
            jsonObject.put("multiSpec", false);
            jsonObject.put("name", "自动化创建单规格" + RandomStringUtil.randomString(2));
            jsonObject.put("xcxSaleState", "YES");
            JSONObject jsonObject2 = new JSONObject();

            jsonObject2.put("inventory", "10");
            jsonObject2.put("price", "0.01");

            jsonObject.put("singleSpecInfo", jsonObject2);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
            JSONObject response = xmAppApi.getBodyInJSON();
            studioResult2=response.getString("result");


            //校验：
            //校验1：获取B端物品列表
            //①统计值增加1
            //②有对应的商品id
            JSONObject afterStudioGoods = goodTools.studioGoods();
            int afterTotal = Integer.parseInt(afterStudioGoods.getJSONObject("result").getString("total"));
            JSONArray records = afterStudioGoods.getJSONObject("result").getJSONArray("records");

            boolean success=false;
            for (int i = 0; i < records.size(); i++) {
                if (records.getJSONObject(i).getString("id").equals(studioResult2)) {
                    success=true;
                }
                Assert.assertEquals(success, true, "新建三个规格的物品成功，但物品列表未找到对应增加的物品ID");
            }
            Assert.assertEquals(afterTotal, beforeTotal + 1, "新建三个规格的物品成功，但物品列表的统计值未增加");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

//            //校验：
//            //校验2：获取C端物品列表
//            //①统计值增加1
//            //②有对应的商品id
//            JSONObject afterPageXcxHomeGoods_C = goodCTools.pageXcxHomeGoods_C(info);
//            int afterTotal_C = Integer.parseInt(afterPageXcxHomeGoods_C.getJSONObject("result").getString("total"));
//            JSONArray records_C = afterPageXcxHomeGoods_C.getJSONObject("result").getJSONArray("records");
//
//            boolean success_C=false;
//            for (int i = 0; i < records_C.size(); i++) {
//                if (records_C.getJSONObject(i).getString("id").equals(studioResult2)) {
//                    success_C=true;
//                }
//                Assert.assertEquals(success_C, true, "新建三个规格的物品成功，但C端的物品列表未找到对应增加的物品ID");
//            }
//            Assert.assertEquals(afterTotal_C, beforeTotal_C + 1, "新建三个规格的物品成功，但C端物品列表的统计值未增加");


            //校验3：获取B端物品详情,状态是开启，小程序售卖也是开启
            JSONObject getDetail_goods=goodTools.getDetail_goods(studioResult2);
            String state=getDetail_goods.getJSONObject("result").getString("state");
            String xcxSaleState=getDetail_goods.getJSONObject("result").getString("xcxSaleState");
            Assert.assertEquals(state,"YES","新建物品是启用，但物品详情展示非启用");
            Assert.assertEquals(xcxSaleState,"YES","新建物品是开启小程序售卖，但物品详情展示非开启小程序售卖");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
//
//            //校验4：获取C端物品详情,状态是开启，小程序售卖也是开启
//            JSONObject getDetail_goods_C=goodCTools.getDetail_goods_C(studioResult2,info);
//            String state_C=getDetail_goods_C.getJSONObject("result").getString("state");
//            String xcxSaleState_C=getDetail_goods_C.getJSONObject("result").getString("xcxSaleState");
//            Assert.assertEquals(state_C,"YES","新建物品是启用，但C端物品详情展示非启用");
//            Assert.assertEquals(xcxSaleState_C,"YES","新建物品是开启小程序售卖，但C端物品详情展示非开启小程序售卖");




        }
    }

    @Test(description = "数据清理",priority = 1)
    public void deleteGood()throws InterruptedException{

        goodTools.deleteGoods(studioResult1);//删除新建的多规格物品

        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        goodTools.deleteGoods(studioResult2);//删除新建的单规格物品

    }

//    @Test(description ="循环")
//    public void xun(){
//        for (int i = 0; i < 20; i++) {
//            testCreateGoods();
//        }
//    }
    }



