package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.setting.venue.VenueAreaTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author adu
 * data 2024/6/13 14:31
 */

public class TestEditGroupRuleSchedule extends BaseTestImpl {
    @Resource(name = "courseTools")
    CourseTools courseTools;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;

    //前天的时间戳，开始时间
    String theDayBeforeYesterdayTimeTamp = CommUtil.oneKeyGetAddDay(-2);
    //获取今天+12天后日期的时间戳（结束时间）
    String endDateTimeTamp = CommUtil.getNDayEndTimeTamp(12);
    String todayEndDateTimeTamp = CommUtil.getNDayEndTimeTamp(0);


    String courseName = "阿杜自动化团课课程";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_editGroupRuleSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "测试编辑团课规则")
    public void testEditGroupRuleSchedule() {
        //先创建排课规则
        //获取存量课程ID
        String courseId = groupScheduleTools.getStockGroupCourseId(courseName);
        //获取存量教练
        List<String> chiefCoachId = new ArrayList<>();
        chiefCoachId.add("杜君丽");
        String chiefCoachIdS = groupScheduleTools.getStudioAdminId(chiefCoachId).get(0).toString();
        //获取存量助教
        List<String> assistCoachIds = new ArrayList<>();
        assistCoachIds.add("木头");
        assistCoachIds.add("吴彦祖");
        List<String> assistCoachIdS = groupScheduleTools.getStudioAdminId(assistCoachIds);
        //1-创建排课日程
        groupScheduleTools.createGroupRuleSchedule(courseId, chiefCoachIdS, theDayBeforeYesterdayTimeTamp, endDateTimeTamp, new ArrayList<>(), assistCoachIdS, false, 1,720);
        //2-查询排课日程
        JSONArray result = groupScheduleTools.getGroupRuleScheduleList(courseId, chiefCoachIdS);
        Assert.assertTrue(result.size() >= 1);
        String ruldId = XMJSONPath.readPath(result.getJSONObject(0), "$.ruleId");
        //3-编辑排课日程
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("chiefCoachId", chiefCoachIdS);
        body.put("minMemberNum", 5);//改变了有2->5
        body.put("maxMemberNum", 20);//改变了999->20
        body.put("minuteOffset", "1320");
        List<String> venueAreaIds = groupScheduleTools.getStockArea("流星花园秘密基地");
        body.put("venueAreaIds", venueAreaIds); //有空改为有数据
        body.put("assistCoachIds", new ArrayList<>()); //有数据AB改成空
        body.put("ruleId", ruldId);
        body.put("spanMinutes", 50);
        body.put("endDate", todayEndDateTimeTamp); //结束日期缩短了，改成当天结束
        body.put("force", false);
        body.put("retainBooking", true);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);

        //4-查看日程详情，check修改内容是否同步变更
        groupScheduleTools.getGroupRuleScheduleDetail(ruldId);
        String detailResult = dataApi.getApi_response();
        Assert.assertEquals(XMJSONPath.readPath(detailResult,"$.result.chiefCoachId"),chiefCoachIdS);
        Assert.assertEquals(XMJSONPath.readPath(detailResult,"$.result.minMemberNum"),"5");
        Assert.assertEquals(XMJSONPath.readPath(detailResult,"$.result.maxMemberNum"),"20");
        Assert.assertEquals(XMJSONPath.readPath(detailResult,"$.result.minuteOffset"),"1320");
        Assert.assertEquals((XMJSONPath.readPath(detailResult,"$.result.endDate").substring(0,9)),todayEndDateTimeTamp.substring(0,9));
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult,"$.result.assistCoachIds").isEmpty(),"助教设置为空后没生效");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult,"$.result.venueAreaIds").containsAll(venueAreaIds),"设置有空改为有数据后没生效");

        //5-删除日程
        groupScheduleTools.delGroupRuleSchedule(ruldId,true);


    }


}

    