package com.xiaomai.cases.polar.experienceCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/13 09:48
 */
public class TestCreateExperienceCard extends XMBaseTest {
    Tools tools = new Tools();
    String id;
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_create")
                .setLoginUser(LoginAccount.ZYX1_DEV)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "创建体验卡")
    public void testCreateExperienceCard() {

        String title = "自动化脚本创建体验卡" + RandomStringUtil.randomString(3);

        //check是否存在同名的体验卡，不存在则新建
        Boolean duplicate = tools.checkTitleDuplicate(title, "EXPERIENCE_CARD").getBoolean("result");
        if (duplicate == false) {
               id = tools.create("EXPERIENCE_CARD",title,"全部","NO","课程次数_入场期限权益").getString("result");
        }

        //新建后校验体验卡第一条数据是新建的那条数据
        String id1 = tools.fetchPageOfMemberCard("EXPERIENCE_CARD","","","","").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        Assert.assertEquals(id,id1);
    }
}
