package com.xiaomai.cases.polar.utils;

import com.xiaomai.cases.polar.enums.ExcelImportEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import java.io.*;
import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/2 17:47
 */
public class ModifyExcelContentUtil {
    private static final Logger logger = Logger.getLogger(ModifyExcelContentUtil.class);
    /**
     * 修改excel中的姓名和手机号信息
     * @param fileUrl
     * @param sheetName
     * @param importBusinessEnum  业务类型
     */

    public static void modifyExcel(String fileUrl, String sheetName, ExcelImportEnum importBusinessEnum){
        int rowIndex=0;
        int nameCellIndex=0;
        int phoneCellIndex=1;
        Long now = System.currentTimeMillis();
        Random random = new Random(now);
        String name="";
        rowIndex=importBusinessEnum.getRowStartIndex();
        nameCellIndex=importBusinessEnum.getCellNametIndex();
        phoneCellIndex=importBusinessEnum.getCellPhoneIndex();
        name = getRandomName("导入线索");

        try {
            InputStream inputStream = new FileInputStream(fileUrl);
            //根据指定的文件输入流导入Excel从而产生Workbook对象
            Workbook workbook = new HSSFWorkbook(inputStream);
            //根据sheetname获取Excel文档表单
            Sheet sheet = workbook.getSheet(sheetName);
            //获取第rowIndex行
            Row row = sheet.getRow(rowIndex);
            Long phone = CommonUtil.getRandomPhone(random);
            int nameCount = 1;
            while(row != null && rowIndex < 5010) {
                Cell phoneCell = row.getCell(phoneCellIndex);
                Cell nameCell = row.getCell(nameCellIndex);
                if (StringUtils.isBlank(nameCell.getStringCellValue())) {
                    break;
                }
                phoneCell.setCellValue(phone.toString());
                String realName = name + nameCount;
                //String realName = getRandomName("") + nameCount;
                nameCell.setCellValue(realName);
                nameCount ++;
                phone ++;
                rowIndex ++;
                row = sheet.getRow(rowIndex);
            }
            OutputStream outputStream = new FileOutputStream(fileUrl);
            workbook.write(outputStream);
            outputStream.flush();
            logger.info("-------------------Excel信息修改成功------------------");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /**
     *
     * @param mark  学员姓名打标：比如 在读导入、线索导入;也可以不写
     * @return 学员姓名
     */
    private static String getRandomName(String mark) {
        StringBuilder sb = new StringBuilder();
        String firstName = "杜张王李赵彭柏孙谢钮徐薛劳周程钟郭竺杨黄苏艾楼陈曹蒋牛";
        String nameMiddle="ABCDEFGHIJKLMNOPQRSTUVWXTZ";
        String nameNum="零一二三四五六七八九十";
        Random randomGenerator = new Random();
        int randomInt = randomGenerator.nextInt(firstName.length());
        sb.append(firstName, randomInt, randomInt+1);
        randomInt = randomGenerator.nextInt(nameMiddle.length());
        sb.append(nameMiddle, randomInt, randomInt+1);
        randomInt = randomGenerator.nextInt(nameNum.length());
        sb.append(nameNum, randomInt, randomInt+1);
        sb.append("同学_"+mark);
        return sb.toString();
    }


}
