package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestMemberCardSearch extends XMBaseTest {
    @Resource(name = "cardTools")
    CardTools cardTools;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_commonSearch")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "会员卡列表根据卡名称-全局搜索")
    public void testMemberCardcommonSearch() {
        String memberCardName="次卡-自动化卡"+ RandomStringUtil.randomString(4);
        cardTools.memberCardCreate(memberCardName);//创建随机的名的次卡
        cardTools.fetchPageOfMemberCard("MEMBER_CARD");//创建成功后查询会员卡列表（此处也可以不查询）
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.records").size()>=1,"创建会员卡成功后，会员卡列表数据为空");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].title"),memberCardName,"创建成功后，列表中第一条数据不是显示的该卡");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("title",memberCardName);//这里需要搜索新创建的会员卡
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("commodityCardType","MEMBER_CARD");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(xmAppApi.getApi_response(),"$.result").size()==1,"精确搜索后发现会搜索到的数据不等于1");
        Assert.assertTrue(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.result[0].title").equals(memberCardName),"精确搜索后发现会员卡名称不匹配");


    }
}
