package com.xiaomai.cases.polar.eventRegistration;

import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestGetPurchaseRecordDetail extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Registration)
                .setApiName("API_getPurchaseRecordDetail")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    DataUserInfo info = new DataUserInfo();

    @Resource(name = "userTools")
    UserTools userTools;

    @Resource(name = "EventRegistrationTools")
    EventRegistrationTools EventRegistrationTools;

    @Test(description = "小程序-查看活动票详情")
    public void testgetPurchaseRecordDetail() {
        String memberId = userTools.getMemberInfo().getString("memberId");

        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);//切换B端
        String activityName = "小程序参与" + RandomStringUtil.randomString(5);
        EventRegistrationTools.create(activityName,true, TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),TimeUtils.getToDayTime(23,00),info);//创建并发布活动
        String activityId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result");


        int before1 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.pagePurchaseRecord("WAITING",memberId), "$.result.total"));//未购买时，有几张待参与的活动票
        int before2 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.pagePurchaseRecord("CANCELED",memberId), "$.result.total"));//未购买时，有几张已取消的活动票


        EventRegistrationTools.sellableActivity_getStudioActivityPage("PROCESSING");//进行中的活动报名
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].activityId"), activityId, "目标活动未展示正确");

        EventRegistrationTools.MinsellableActivity_getStudioActivityById(activityId);//查看活动详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "PROCESSING", "目标活动状态不正确");//目标活动为进行中的活动
        String activitySkuId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result.skuItems[0].id");//获取活动购买项目id

        EventRegistrationTools.sellableActivity_checkMemberPurchaseActivity(activityId,activitySkuId,memberId);//活动报名页

        EventRegistrationTools.purchaseSellableActivity(activityId,activitySkuId,memberId);//报名

        int after1 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.pagePurchaseRecord("WAITING",memberId), "$.result.total"));//购买后，有几张待参与的活动票
        Assert.assertEquals(after1,before1+1);
        String recordId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].id");//获取第一张活动票的id

        EventRegistrationTools.getPurchaseRecordDetail(recordId);//查看活动票详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.activityInfo.state"), "PROCESSING", "活动票状态非待参与");//断言活动票详情为待参与

        EventRegistrationTools.BpagePurchaseRecord(activityId,info);//B端查看报名名单
        String voucherId =XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].voucherId");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].memberInfo.id"), memberId, "报名活动人和C端memberid不一致");//断言参与报名的人的member正确

        EventRegistrationTools.sellableActivity_getRecordUserInfo(recordId,info);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].values[0]"), "10000000000", "报名填写的手机号和用户信息不一致");//断言用户信息是否正确
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result[1].values[0]"), "自动化用户名称", "报名填写的姓名和用户信息不一致");//断言用户信息是否正确

        EventRegistrationTools.cancelPurchaseRecord(voucherId,info);//活动报名-取消报名
        EventRegistrationTools.BgetPurchaseRecordDetail(recordId,info);//B端查看报名详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "INVALID", "取消报名未成功");//核对B端报名状态

        EventRegistrationTools.getPurchaseRecordDetail(recordId);//小程序查看活动票详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "INVALID", "取消报名未成功");//核对C端报名状态
        int after2 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.pagePurchaseRecord("CANCELED",memberId), "$.result.total"));//取消报名后，几张已取消的活动票
        Assert.assertEquals(after2,before2+1);

        EventRegistrationTools.deleteById(activityId,info);//删除活动报名
        //Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "INVALID", "取消报名未成功");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.message"),"已有用户参与此活动，不支持删除");

        EventRegistrationTools.sellableActivityInvalid(activityId,info);//失效活动
        EventRegistrationTools.sellableActivity_getStudioActivityById(activityId,info);//查看失效活动
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "ABNORMAL", "未失效活动成功");//断言活动详情返回状态为已失效








    }

}
