package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestUpdateGetdetail extends XMBaseTest {

    Tools tools=new Tools();
    OrderTools orderTools=new OrderTools();
    CardTools cardTools=new CardTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_getDetail")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "修改订单销售业绩-查看订单详情")
    public void testUpdateGetdetail(){

        String ownerId ="1796482784551211010";
        String ownerName="f昵称昵称昵称f昵称昵称昵称f昵称昵称昵";

        JSONObject memberCard=orderTools.fetchPageOfMemberCard("次卡","MEMBER_CARD");
        String cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        BigDecimal quantity= new BigDecimal(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("benefitList").getJSONObject(0).getString("balance"));

        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));

        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        JSONObject orderResult= orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, price / 2, "PURCHASE",
                "MEMBER_CARD", "1805435813468483586", price - price / 2, price - price / 2, "1", true);

        String getDetailId = orderResult.getString("result");

        orderTools.updateBusinessOwnerInfo(ownerId,ownerName,getDetailId,0.25,50);

        orderTools.getDetail(getDetailId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.businessOwners[0].ownerId"), ownerId, "修改订单业绩人错误");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.businessOwners[0].owner.name"), ownerName, "修改订单业绩人错误");


    }



}
