package com.xiaomai.cases.polar.points;

import com.xiaomai.cases.lunar.goods.GoodCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.eventRegistration.EventRegistrationTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.math.BigDecimal;

public class TestPointsMini extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Points)
                .setApiName("API_memberPoint_getAccount")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Resource(name = "userTools")
    UserTools userTools;

    @Resource(name = "pointsMinTools")
    PointsMInTools pointsMinTools;

    GoodCTools goodCTools=new GoodCTools();

    OrderTools orderTools = new OrderTools();

    DataUserInfo info = new DataUserInfo();

    @Resource(name = "EventRegistrationTools")
    com.xiaomai.cases.polar.eventRegistration.EventRegistrationTools EventRegistrationTools;

    @Test(description = "小程序-积分")
    public void testmemberPoint_getAccount() {
        String memberId = userTools.getMemberInfo().getString("memberId");

        //pointsMinTools.memberPoint_getAccount(memberId);
        int BeleftBalance = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员在小程序初始积分数
        System.out.println("BeleftBalance--------"+BeleftBalance);

        goodCTools.purchaseGoods("0.00",null,memberId,"物品积分自动化","100.00","1938148913966530562", BigDecimal.valueOf(100),1);//C端下单不支付
        String id =XMJSONPath.readPath(dataApi.getApi_response(), "$.result.id");

        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);//切换B端
        orderTools.pay(BigDecimal.valueOf(100),"1",id,info);//B端支付

        int AfleftBalance = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员购买物品后，剩余积分数
        Assert.assertEquals(AfleftBalance,BeleftBalance+10);//断言剩余积分数+10

        pointsMinTools.findStatementPage(memberId, String.valueOf(true));
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].initialBalance"), "10", "第一条非加10积分的记录");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "IN_ORDER_CONSUME", "第一条非物品的积分记录");

        //作废订单
        orderTools.discard(id,"订单录错","",info);//B端
        int AfleftBalance1 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员购买物品后，剩余积分数
        Assert.assertEquals(AfleftBalance1,AfleftBalance-10);//断言剩余积分数+10

        pointsMinTools.findStatementPage(memberId, String.valueOf(false));
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].initialBalance"), "-10", "第一条非减去10积分的记录");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "OUT_ORDER_REFUND", "第一条退购买物品的积分记录");

        //活动报名
        String activityName = "积分参与" + RandomStringUtil.randomString(5);
        EventRegistrationTools.create(activityName,true, TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),TimeUtils.getToDayTime(23,00),info);//创建并发布活动
        String activityId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result");

        EventRegistrationTools.MinsellableActivity_getStudioActivityById(activityId);//查看活动详情
        String activitySkuId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result.skuItems[1].id");//获取活动购买项目id
        EventRegistrationTools.purchaseSellableActivity(activityId, String.valueOf(100),activitySkuId,memberId);//报名
        String id1 =XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//订单ID
        System.out.println("id1--------"+id1);
        orderTools.pay(BigDecimal.valueOf(100),"1",id1,info);//B端支付

        int AfleftBalance2 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员购买物品后，剩余积分数
        Assert.assertEquals(AfleftBalance2,AfleftBalance1+10);//断言剩余积分数+10

        //作废订单
        orderTools.discard(id1,"订单录错","",info);//B端
        int AfleftBalance3 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员退物品后，剩余积分数
        Assert.assertEquals(AfleftBalance3,AfleftBalance2-10);//断言剩余积分数-10






    }

}
