package com.xiaomai.cases.polar.eventRegistration;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


@Component("EventRegistrationTools")
public class EventRegistrationTools extends BaseTestImpl {
    /**
     * @param
     * @description:活动报名列表
     * @author: yangjian
     * @param state 活动状态
     **/
    public JSONObject getStudioActivityPage(String state, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_getStudioActivityPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("state", state);//UNPUBLISHED未发布 WAITING报名未开始 PROCESSING报名中 ENDED报名结束 ABNORMAL已失效
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:搜索活动报名
     * @author: yangjian
     * @param activityNameLike 活动名称
     **/
    public JSONObject SearchActivity(String activityNameLike, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_getStudioActivityPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("activityNameLike", activityNameLike);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @param activityName 活动名称
     * @param publish 发布状态
     * @param activityStartTime 活动开始时间
     * @param activityEndTime 活动结束时间
     * @param sellableStartTime 报名开始时间
     * @param sellableEndTime 报名结束时间
     * @description:创建活动报名
     * @author: yangjian
     *
     * @return*/
    public JSONObject create(String activityName, boolean publish,  long activityStartTime, long activityEndTime, long sellableStartTime, long sellableEndTime, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_sellableActivity_create")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> applyMemberStates = new ArrayList<>();//可参与会员类型
        applyMemberStates.add("POTENTIAL");
        applyMemberStates.add("NORMAL");
        applyMemberStates.add("HISTORY");

        JSONObject jsonObject3 = new JSONObject();//姓名收集
        jsonObject3.put("configName", "姓名");
        jsonObject3.put("configType","TEXT");
        jsonObject3.put("required", true);

        JSONObject jsonObject4 = new JSONObject();//手机号收集
        jsonObject4.put("configName", "手机号");
        jsonObject4.put("configType","TEXT");
        jsonObject4.put("required", true);

        List<JSONObject> userInfoConfig = new ArrayList<>();//用户信息收集
        userInfoConfig.add(jsonObject3);
        userInfoConfig.add(jsonObject4);

        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("price", 0);//报名价格为0元
        jsonObject1.put("purchaseNumberLimit", -1);//购买限制
        jsonObject1.put("skuName", "自动化-报名项目");
        jsonObject1.put("stock", "100");//剩余数量
        List<JSONObject> skuItems = new ArrayList<>();//报名项目
        skuItems.add(jsonObject1);

        JSONObject jsonObject2 = new JSONObject();//活动地点
        jsonObject2.put("address", "同人广场A座");
        jsonObject2.put("provinceCode",330000);
        jsonObject2.put("cityCode", 330100);
        jsonObject2.put("areaCode", 330106);
        jsonObject2.put("fullAddress", "浙江省杭州市西湖区同人广场A座");

        List<String> hostGraphIds = new ArrayList<>();//固定活动主图
        hostGraphIds.add("1896827628887764994");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("publish", publish);// false仅保存 true保存并发布
        jsonObject.put("activityName", activityName);//活动报名的名称
        jsonObject.put("activityStartTime", activityStartTime);//活动开始时间
        jsonObject.put("activityEndTime", activityEndTime);//活动结束时间
        jsonObject.put("sellableStartTime", sellableStartTime);//报名开始时间
        jsonObject.put("sellableEndTime", sellableEndTime);//报名结束时间
        jsonObject.put("applyMemberStates", applyMemberStates);//可参与会员类型，所有会员类型
        jsonObject.put("skuItems", skuItems);//报名项目
        jsonObject.put("hostGraphIds", hostGraphIds);//活动主图
        //jsonObject.put("activityDesc",activityDesc );//活动描述
        jsonObject.put("userInfoCollect", true);//用户信息收集  true、false
        //jsonObject.put("delSkuItemIds", delSkuItemIds);
        jsonObject.put("addressInfo", jsonObject2);
        jsonObject.put("userInfoConfig", userInfoConfig);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:删除活动报名
     * @author: yangjian
     * @param activityId 活动id
     **/
    public JSONObject deleteById(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_deleteById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:失效活动报名
     * @author: yangjian
     * @param activityId 活动id
     **/
    public JSONObject sellableActivityInvalid(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_sellableActivity_invalid")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:查看报名名单
     * @author: yangjian
     * @param activityId 活动id
     **/
    public JSONObject pagePurchaseRecord(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_pagePurchaseRecord")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("current", 0);
        jsonObject.put("size", 10);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:发布活动报名
     * @author: yangjian
     * @param activityId 活动id
     **/
    public JSONObject sellableActivity_publish(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_sellableActivity_publish")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:编辑活动报名
     * @author: yangjian
     * @param activityId 活动id
     * @param publish 发布状态
     * @param activityName 活动名称
     * @param activityStartTime 活动开始时间
     * @param activityEndTime 活动结束时间
     * @param sellableStartTime 报名开始时间
     * @param sellableEndTime 报名结束时间

     **/

    public JSONObject edit(String activityName, boolean publish, long activityStartTime, long activityEndTime, long sellableStartTime, long sellableEndTime,String activityId,String skuId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_sellableActivity_edit")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> applyMemberStates = new ArrayList<>();//可参与会员类型
        applyMemberStates.add("POTENTIAL");
        applyMemberStates.add("NORMAL");
        applyMemberStates.add("HISTORY");

        JSONObject jsonObject3 = new JSONObject();//姓名收集
        jsonObject3.put("configName", "姓名");
        jsonObject3.put("configType","TEXT");
        jsonObject3.put("required", true);

        JSONObject jsonObject4 = new JSONObject();//手机号收集
        jsonObject4.put("configName", "手机号");
        jsonObject4.put("configType","TEXT");
        jsonObject4.put("required", true);

        List<JSONObject> userInfoConfig = new ArrayList<>();//用户信息收集
        userInfoConfig.add(jsonObject3);
        userInfoConfig.add(jsonObject4);


        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("activityId", activityId);
        jsonObject1.put("price", 0);//报名价格为0元
        jsonObject1.put("purchaseNumberLimit", -1);//购买限制
        jsonObject1.put("skuName", "自动化-报名项目");
        jsonObject1.put("stock", "100");//剩余数量
        jsonObject1.put("skuId", skuId);//剩余数量？？

        List<JSONObject> skuItems = new ArrayList<>();//报名项目
        skuItems.add(jsonObject1);

        JSONObject jsonObject2 = new JSONObject();//活动地点
        jsonObject2.put("address", "同人广场A座");
        jsonObject2.put("provinceCode",330000);
        jsonObject2.put("cityCode", 330100);
        jsonObject2.put("areaCode", 330106);
        jsonObject2.put("fullAddress", "江省杭州市西湖区同人广场A座");

        List<String> hostGraphIds = new ArrayList<>();//固定活动主图
        hostGraphIds.add("1896738511109779458");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("publish", publish);// false仅保存 true保存并发布
        jsonObject.put("activityName", activityName);//活动报名的名称
        jsonObject.put("activityStartTime", activityStartTime);//活动开始时间
        jsonObject.put("activityEndTime", activityEndTime);//活动结束时间
        jsonObject.put("sellableStartTime", sellableStartTime);//报名开始时间
        jsonObject.put("sellableEndTime", sellableEndTime);//报名结束时间
        jsonObject.put("applyMemberStates", applyMemberStates);//可参与会员类型，所有会员类型
        jsonObject.put("skuItems", skuItems);//报名项目
        jsonObject.put("hostGraphIds", hostGraphIds);//活动主图
        //jsonObject.put("activityDesc",activityDesc );//活动描述
        jsonObject.put("userInfoCollect", true);//用户信息收集  true、false
        //jsonObject.put("delSkuItemIds", delSkuItemIds);
        jsonObject.put("addressInfo", jsonObject2);
        jsonObject.put("userInfoConfig", userInfoConfig);
        jsonObject.put("activityId", activityId);//活动id

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:查看活动详情
     * @author: yangjian
     * @param activityId 活动id
     **/
    public JSONObject sellableActivity_getStudioActivityById(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_sellableActivity_getStudioActivityById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }









}
