package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.studioConfig.ConfigTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-03-01  10:45
 * @Description: 编辑员工
 * @Version: 1.0
 */
public class TestEditStudioAdmin extends BaseTestImpl {
    @Resource(name = "configTools")
    ConfigTools configTools;
    @Resource(name = "adminTools")
    AdminTools adminTools;
    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Admin,"API_editStudioAdmin", LoginAccount.GYM_PROD2, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testEditStudioAdmin() {
        String body = "{\"size\":10,\"current\":0}";
        JSONObject adminPage = adminTools.pageStudioAdmin(body);
        int total = Integer.parseInt(adminPage.getJSONObject("result").getString("total"));
        if (total>1){
            int pages = Integer.parseInt(adminPage.getJSONObject("result").getString("pages"));
            // 随机获取一页
            Random rand = new Random();
            int pageIndex = rand.nextInt(pages);
            // 随机获取一页的随机员工
            Random random = new Random();
            int index = pageIndex+1 ==  pages ? random.nextInt(total%20-1)+1 : random.nextInt(19)+1;
            body = "{\"size\":20,\"current\":"+pageIndex+",\"state\":\"DUTY\"}";
            adminPage = adminTools.pageStudioAdmin(body);

            String adminId = adminPage.getJSONObject("result").getJSONArray("records").getJSONObject(index).getString("id");
            String phone = adminPage.getJSONObject("result").getJSONArray("records").getJSONObject(index).getString("phone");

            // 修改的请求参数
            JSONObject requestBody = new JSONObject();

            String entryType = "FULL_TIME";  // 全职
//            entryType.add("PART_TIME"); // 兼职
//            entryType.add("PRACTICE"); // 实习
            requestBody.put("entryType",entryType);

            requestBody.put("gender","MAN"); // 性别

            Long birthDate = TimeUtils.getBeforeDayDate(7305); // 20年前 生日
            requestBody.put("birthDate",birthDate);

            Long entryTime = TimeUtils.getBeforeDayDate(7); // 入职日期
            requestBody.put("entryDate",entryTime);

            String memo = "修改员工备注信息"; // 备注
            requestBody.put("memo",memo);

            String name = RandomStringUtil.random_name();
            String editName = name + TimeUtils.getCurrentTime();
            requestBody.put("name",editName);

            String editNickName = name +  TimeUtils.getCurrentTime();
            requestBody.put("nickName",editNickName); // 昵称

            JSONObject avatar = new JSONObject(); // 头像
            avatar.put("content",editNickName.charAt(editNickName.length() - 1));
            requestBody.put("avatar",avatar);

            JSONArray roles = new JSONArray(); // 角色
            roles.add("StudioCoach"); // 教练
            roles.add("StudioSaleManager"); // 销售
            requestBody.put("roles",roles);

            JSONObject teaching = new JSONObject(); // 教练
            teaching.put("teaching",true);
            JSONArray coachTeachingTypes = new JSONArray(); // LEAGUE_CLASS, PERSONAL_TRAINERS, TRAINING_CAMP   "团课", "私教", "训练营"
            coachTeachingTypes.add("LEAGUE_CLASS");  // 团课
            coachTeachingTypes.add("PERSONAL_TRAINERS");  //私教
            coachTeachingTypes.add("TRAINING_CAMP");  //训练营
            teaching.put("coachTeachingTypes",coachTeachingTypes);
            requestBody.put("teaching",teaching);
            requestBody.put("phone",phone);
            requestBody.put("id",adminId); //员工id

            xmAppApi.doRequest(RequestType.JSON,params,requestBody.toString(),headers).assetsSuccess(true);

            JSONObject adminInfo = adminTools.getStudioAdmin(adminId);

            String[] resultString = {"id","phone","name","nickName","gender","avatar","roles","teaching","birthDate","entryDate","memo"};  // 修改之后验证的值
            for (int i = 0; i < resultString.length; i++){
                String result = adminInfo.getJSONObject("result").getString(resultString[i]);
                System.out.println("-------"+resultString[i]);
                if (resultString[i].equals("roles")){
                    JSONArray arr = new JSONArray();
                    for (int j=0;j<adminInfo.getJSONObject("result").getJSONArray(resultString[i]).size();j++){
                        arr.add(adminInfo.getJSONObject("result").getJSONArray(resultString[i]).getJSONObject(j).getString("code"));
                    }
                    result = arr.toJSONString();
                    System.out.println("---------------2"+result);
                }
                Assert.assertEquals(result, requestBody.getString(resultString[i]));
                System.out.println(resultString[i] + " : " + result);
                System.out.println(adminInfo.getJSONObject("result").getString(resultString[i]));
            }
            try {
                Thread.sleep(15000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            // check 2: 生成对应的操作日志
            body = "{\"current\":0,\"size\":10,\"domainId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"content\": \""+name+"\",\"brandId\": \""+xmAppApi.getLoginInfo().getBrandId()+"\",\"studioId\": \""+xmAppApi.getLoginInfo().getStudioId()+"\",\"opEventKey\":\"EDIT_ADMIN\"}";
            JSONObject response = configTools.getOpauditPage(body);
            Assert.assertEquals(response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONObject("target").getString("targetId"),adminId,"编辑员工未生成操作日志");

        }

    }
}
