package com.xiaomai.cases.polar.applet;

import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 16:25
 */
public class TestSetStyleConfig extends XMBaseTest {
    AppletTools appletTools = new AppletTools();

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_setStyleConfig")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "修改小程序全局配置")
    public void testSetStyleConfig(){
        Random random = new Random();
        String[] themeColor = {"132, 111, 234","40, 115, 255","51, 202, 105"};//紫、蓝、绿
        String body = "{\"tenantId\":\"1796482011391729666\",\"tenantType\":\"BRAND\",\"config\":{\"loadingImage\":\"https://image.xiaomaiketang.com/xm/internal/bYk7k24Dwy.gif\",\"loginType\":\"DEFAULT\",\"defaultStyle\":{\"GRAPHIC_NAVIGATION\":{\"STUDIO_INTRO\":\"https://image.xiaomaiketang.com/xm/internal/5rHR854HrG.png\",\"BRAND_STORY\":\"https://image.xiaomaiketang.com/xm/internal/MP86aN8bGr.png\",\"COACH_TEAM\":\"https://image.xiaomaiketang.com/xm/internal/RRd4JjKFAa.png\",\"BOOK_LESSON\":\"https://image.xiaomaiketang.com/xm/internal/P7aNhwMX2m.png\",\"MEMBER_CARD\":\"https://image.xiaomaiketang.com/xm/internal/jp78pZnSt5.png\",\"EXPERIENCE_CARD\":\"https://image.xiaomaiketang.com/xm/internal/NFrcRw6iE2.png\"},\"TABS\":{\"SEL\":{\"HOME\":\"icon-a-xiaochengxushouye\",\"CLASS\":\"icon-a-xiaochengxuyuyue\",\"MINE\":\"icon-a-xiaochengxuwode\"},\"UN_SEL\":{\"HOME\":\"icon-a-xiaochengxushouye\",\"CLASS\":\"icon-a-xiaochengxuyuyue\",\"MINE\":\"icon-a-xiaochengxuwode\"}},\"bgUrl\":\"https://image.xiaomaiketang.com/xm/internal/TRcJHBMjyj.png\"},\"themeColor\":\""+themeColor[random.nextInt(3)]+"\",\"loadLoading\":false,\"tabs\":[{\"code\":\"HOME\",\"visible\":true,\"iconUnselected\":\"icon-a-xiaochengxushouye\",\"iconSelected\":\"icon-a-xiaochengxushouye\",\"title\":\"首页\"},{\"code\":\"CLASS\",\"visible\":true,\"iconUnselected\":\"icon-a-xiaochengxuyuyue\",\"iconSelected\":\"icon-a-xiaochengxuyuyue\",\"title\":\"预约\"},{\"code\":\"MINE\",\"visible\":true,\"iconUnselected\":\"icon-a-xiaochengxuwode\",\"iconSelected\":\"icon-a-xiaochengxuwode\",\"title\":\"我的\"}],\"emptyImage\":\"https://image.xiaomaiketang.com/xm/internal/SxaKWnkEyK.png\",\"themeStyle\":\"LIGHT\",\"themeKey\":\"EXERCISE\",\"colors\":{\"primaryColor\":\"#15171F\",\"secondaryColor\":\"#434656\",\"thirdColor\":\"#73778C\",\"tipsColor\":\"#AFB1BC\",\"cardBgColor\":\"#FFFFFF\",\"specialColor\":\"#C9CDD4\",\"bgColor\":\"#F5F7FA\",\"borderColor\":\"#EEF0F7\",\"rgbCardBgColor\":\"255,255,255\"},\"emptyLoading\":false},\"theme\":\"EXERCISE\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);

        String str = appletTools.getStyleConfig().getJSONObject("result").getString("themeColor");
        Assert.assertEquals(true, str.equals("132, 111, 234") || str.equals("40, 115, 255")||str.equals("51, 202, 105"));

    }
}
