package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestCancelSuspend extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_cancelSuspend")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "会员卡售卖记录详情-取消停用")
    public void testcancelSuspend() {
        CardTools Cardtools = new CardTools();
        Cardtools.membercardsearch("NORMAL");

        String benefitId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].courseBenefit.id");//拿售卖记录第一张【生效中】售卖的会员卡的ID;
        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿售卖记录第一张【生效中】会员卡的ID;

        Cardtools.modifyExpireDate(benefitId,memberCardId);//修改有效期
        Cardtools.getMemberCardAccountOperateRecord(memberCardId);//查看售卖记录变动记录
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].operateType").equals("CHANGE_EFFECTIVE_DATE"),"操作修改有效期，变动记录第一条操作类型");
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].remark").equals("自动化修改会员卡有效期"),"操作修改有效期，变动记录第一条的备注");

        //Cardtools.membercardfindDetailById(memberCardId);//获取售卖记录详情
        //long expireDate = TimeUtils.getAfterDayDate(1);
        //System.out.println(expireDate);
        //Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].expireDate").equals(expireDate));//校验售卖记录，有效期是否修改正确
        //Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].expireDate")..equals(expireDate),substring(0, 5););

        Cardtools.membercard_suspend(benefitId,memberCardId);//会员卡操作停卡
        Cardtools.membercardfindDetailById(memberCardId);//获取售卖记录详情
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.state").equals("SUSPEND"),"校验停卡后，售卖记录详情-状态变更为已停用");

        Cardtools.getMemberCardAccountOperateRecord(memberCardId);//查看售卖记录变动记录
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].operateType").equals("SUSPEND_CARD"),"操作停卡，变动记录第一条操作类型");
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].remark").equals("自动化停卡"),"操作停卡，变动记录第一条的备注");



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memo","自动化取消停卡");
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Cardtools.getMemberCardAccountOperateRecord(memberCardId);//查看售卖记录变动记录
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].operateType").equals("CANCEL_SUSPEND_CARD"),"操作取消停卡，变动记录第一条操作类型");
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].remark").equals("自动化取消停卡"),"操作取消停卡，变动记录第一条的备注");

    }
}
