package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestDiscardManualDeduct extends XMBaseTest {

    @Resource(name = "cardTools")
    CardTools cardTools;

    public String benefitId;
    public String memberCardId = "";

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_discardManualDeduct")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @DataProvider
    public  Object[][] dataProvider(){
        return new Object[][]{
                {"MEMBER","1.00"},//会员卡，扣整数
                {"EXPERIENCE","1.00"},//体验卡，扣整数
                {"DEPOSIT","0.01"}//储值卡,扣小数
        };
    }
    @Test(description = "手动扣次-->撤销手动扣次",dataProvider = "dataProvider")
    public void testDiscardManualDeduct(String cardType,String balance) throws InterruptedException {
        //查询生效中的卡列表
        cardTools.memberCardSearch(cardType,"NORMAL");
        //先检查列表有没有数据，有数据才会执行下面的点代码（如果是个空机构，肯定不会被执行，想从存量数据中获取，需要自己先造个数据）
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿售卖记录第一张【生效中】会员卡的ID;
            if(cardType=="DEPOSIT"){
                benefitId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].depositBenefit.id");//储值卡权益id;
            }else{
                benefitId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].courseBenefit.id");//会员卡/体验卡权益id;
            }
            //先查询消耗记录的条数
            int num = Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId),"$.result.total"));
            //对卡操作手动扣次
            cardTools.manualDeduct(benefitId,memberCardId,balance);
            //获取手动扣次生成的消耗记录id
            String consumeRecordId = XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId), "$.result.records[0].id");
            //check卡的消耗记录新增1条记录,并且校验消耗记录的类型及扣除次数的准确性
            Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId),"$.result.total"))==num+1);
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId),"$.result.records[0].consumeType").equals("MANUAL_DEDUCT"),"操作手动扣次，消耗记录第一条操作类型");
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId),"$.result.records[0].changeOfPurchaseBalance").equals("-" + balance),"操作手动扣次，消耗次数");

            //构建参数
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("consumeRecordId",consumeRecordId);
            jsonObject.put("memberCardId",memberCardId);
            jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

            //调用请求
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

            //check卡的消耗记录再次新增1条记录,并且校验消耗记录的类型及扣除次数的准确性
            Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId),"$.result.total"))==num+2);
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId),"$.result.records[0].consumeType").equals("MANUAL_DEDUCT"),"操作手动扣次，消耗记录第一条操作类型");
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId),"$.result.records[0].changeOfPurchaseBalance").equals(balance),"操作手动扣次，消耗次数");

            Thread.sleep(3000);
        }
    }
}
