package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestModifySharers extends XMBaseTest {
    @Resource(name = "cardTools")
    CardTools cardTools;
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;

    @Resource(name = "memberTools")
    MemberTools memberTools;


    public String memberCardId = "";
    public String sharePeopleLimit;
    public String memberId;
    
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifySharers")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public  Object[][] dataProvider(){
        return new Object[][]{
                {"MEMBER"},//会员卡
                {"DEPOSIT"},//储值卡
                {"EXPERIENCE"}//体验卡
        };
    }
    @Test(description = "添加共享人-->移除共享人",dataProvider = "dataProvider")
    public void testModifySharers(String cardType) {
        //查询生效中的卡列表
        cardTools.memberCardSearch(cardType,"NORMAL");
        //先检查列表有没有数据，有数据才会执行下面的点代码（如果是个空机构，肯定不会被执行，想从存量数据中获取，需要自己先造个数据）
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
            //取出第一个数据后，要check下会员卡的启用状态，想停用，要保证卡的状态目前就是启用状态
//            sharePeopleLimit = Integer.parseInt(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].sharePeopleLimit"));
            //如果共享人数=0，设置共享人=2
//            if(sharePeopleLimit == 0){
//                cardTools.memberCardCancelSuspend(memberCardId);//进行卡编辑，共享人设置=2
//            }

            //获取该卡的变动记录条数
            int num = Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.total"));
            //获取该卡当前的共享人数
            int sharerNum = XMJSONPath.getJSONArrayByReadPath(cardTools.memberCardFindDetailById(memberCardId), "$.result.sharers").size();

            //获取共享人列表里其中是「流失会员」的会员id
            memberId = trainingTools.searchTargerMember("自动化流失会员");
            Assert.assertEquals(XMJSONPath.readPath(memberTools.findStudioMemberDetail(memberId), "$.result.status"),"HISTORY");
            //查询该会员名下卡数据
            cardTools.getUserMemberCardList(memberId,cardType);
            int cardNum = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size();

            //构建接口参数
            JSONArray sharerIds = new JSONArray();
            sharerIds.add(memberId);

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("memberCardId", memberCardId);
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            jsonObject.put("sharerIds", sharerIds);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());

            //调用请求
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

            //check 会员卡详情，共享人新增1条
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(cardTools.memberCardFindDetailById(memberCardId), "$.result.sharers").size()==sharerNum+1);

            //check 变动记录新增1条数据
            Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.total"))==num+1);
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.records[0].operateType").equals("CHANGE_SHARER"),"操作添加共享人，变动记录第一条操作类型");
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.records[0].content").contains("添加"),"操作添加共享人，变动记录第一条的备注");

            //check 会员状态从流失->正式
            Assert.assertEquals(XMJSONPath.readPath(memberTools.findStudioMemberDetail(memberId), "$.result.status"),"NORMAL");
            //check 会员已购卡新增1张
            cardTools.getUserMemberCardList(memberId,cardType);
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size()==cardNum+1);

            //数据清理:移除共享人
            cardTools.modifySharers(memberCardId);
            //check 会员状态从正式->流失
            Assert.assertEquals(XMJSONPath.readPath(memberTools.findStudioMemberDetail(memberId), "$.result.status"),"HISTORY");
        }
    }
}
