package com.xiaomai.cases.polar.memberCard.MemberCardTimeSale;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.cases.polar.studioConfig.MerchantTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

public class Testflashsaleedit extends BaseTestImpl {
    @Resource(name = "cardTools")
    CardTools cardTools;
    @Resource(name = "memberCardTimeSaleTools")
    MemberCardTimeSaleTools MemberCardTimeSaleTools;
    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Card, "API_flashsaleedit", LoginAccount.ADU_PROD, Terminal.B, "yangjian");
        super.beforeTest();
    }



    @Test(description = "编辑秒杀活动动")
    public void testFlashsaleedit() throws InterruptedException {
        Thread.sleep(2000);
        String cardId = cardTools.memberCardCreate("用于秒杀活动的会员卡"+ TimeUtils.getCurrentTime()).getString("result");//创建一张用于秒杀活动的会员卡

        JSONObject result =MemberCardTimeSaleTools.getStudioActivityPage1("");//所有活动条数;
        int beforecount=Integer.parseInt(result.getJSONObject("result").getString("total"));
        String title ="秒杀活动"+ TimeUtils.getCurrentTime();
        String activeid = MemberCardTimeSaleTools.create(cardId,title,true,TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()).getString("result");//创建并发布一个秒杀活动

        JSONObject result1 =MemberCardTimeSaleTools.getStudioActivityPage1("");//所有活动条数;
        int aftercount1=Integer.parseInt(result1.getJSONObject("result").getString("total"));

        Assert.assertEquals(aftercount1,beforecount+1);//创建秒杀活动后，秒杀活动列表+1
        Assert.assertTrue(XMJSONPath.readPath(MemberCardTimeSaleTools.getStudioActivityPage("PROCESSING"),"$.result.records[0].activityId").equals(activeid),"活动列表非创建活动");//创建活动后断言，列表第一条进行中数据为新建活动
        Assert.assertTrue(XMJSONPath.readPath(MemberCardTimeSaleTools.getStudioActivityPage1(title),"$.result.records[0].activityName").equals(title),"搜索结果非新建活动");//创建活动后断言，列表能正常搜索道

        JSONObject jsonObject = new JSONObject();//修改活动名称+修改活动剩余库存数量
        List<String> applyMemberStates = new ArrayList<>();
        applyMemberStates.add("POTENTIAL");
        applyMemberStates.add("NORMAL");
        applyMemberStates.add("HISTORY");

        jsonObject.put("activityName", "编辑后的秒杀活动");
        jsonObject.put("activityType", "SECKILL");//活动类型为秒杀
        jsonObject.put("endTime", TimeUtils.getTodayEndTime());//活动结束时间为今天24点
        jsonObject.put("startTime", TimeUtils.getTodayTime());//活动开始时间为今天0点
        jsonObject.put("applyMemberStates", applyMemberStates);//活动可参与用户
        jsonObject.put("autoCancelMinutes", "5");//自动取消订单时间
        jsonObject.put("commodityId", cardId);//活动的会员卡商品
        jsonObject.put("commodityType", "MEMBER_CARD");//商品类型，目前仅有会员卡
        jsonObject.put("initSalesVolumeShow", "10");//初始秒杀数量显示
        jsonObject.put("purchaseNumberLimit", -1);//购买数量限制：不限制
        jsonObject.put("reserveReminder", true);//秒杀数量是否展示
        jsonObject.put("specialPrice", "0");//秒杀价格0元
        jsonObject.put("publish", "true");//是否发布
        jsonObject.put("stock", "11");//库存数
        jsonObject.put("activityId",activeid);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        MemberCardTimeSaleTools.getStudioActivityById(activeid);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.activityName"), "编辑后的秒杀活动", "目标活动没有修改成功");//断言目标活动名字变更
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.stock"), "11", "目标活动库存数没有修改成功");//断言目标活动库存数量变更

        MemberCardTimeSaleTools.getStatisticsData(activeid);//查看活动数据
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.totalStock"), "11", "目标活动库存数没有修改成功");//断言目标活动库存数量变更

        MemberCardTimeSaleTools.getStudioActivityById(activeid);
        String supplierId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result.sourceId");//获取supplierId

        MemberCardTimeSaleTools.pageVoucher(activeid,supplierId);//查看活动详情-订单数据
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$success"), "true", "活动详情订单数据没有访问成功");




        JSONObject result2 =MemberCardTimeSaleTools.getStudioActivityPage("ABNORMAL");//所有活动条数;
        int count1=Integer.parseInt(result2.getJSONObject("result").getString("total"));
        MemberCardTimeSaleTools.studioSeckillInvalid(activeid);//失效活动
        JSONObject result3 =MemberCardTimeSaleTools.getStudioActivityPage("ABNORMAL");//活动后活动条数
        int count2=Integer.parseInt(result3.getJSONObject("result").getString("total"));
        Assert.assertEquals(count2,count1+1);//失效活动+1
        MemberCardTimeSaleTools.getStudioActivityById(activeid);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "ABNORMAL", "目标活动没有失效状态");//断言目标活动变成失效状态



        MemberCardTimeSaleTools.studioSeckillDeleteById(activeid);//删除秒杀活动
        JSONObject result4 =MemberCardTimeSaleTools.getStudioActivityPage1("");//删除活动后活动条数
        int aftercount2=Integer.parseInt(result4.getJSONObject("result").getString("total"));

        Assert.assertEquals(aftercount2,aftercount1-1);//删除秒杀活动后，秒杀活动列表-1








    }
}
