package com.xiaomai.cases.polar.reserve.group;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.math.BigDecimal;


public class TestBatchReserveGroup extends BaseTestImpl {


    @Resource(name = "reserveTools")
    ReserveTools reserveTools;

    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;

    MemberTools memberTools = new MemberTools();

    OrderTools orderTools = new OrderTools();
    CardTools cardTools = new CardTools();

    Tools tools = new Tools();

    private String courseId="1848906529522774018";

    //7个课次id
    String scheduleId1;
    String scheduleId2;
    String scheduleId3;
    String scheduleId4;
    String scheduleId5;
    String scheduleId6;
    String scheduleId7;
    String memberId1;
    String memberId2;

    JSONArray getScheduleItemDetailReserveId1=new JSONArray();
    JSONArray getScheduleItemDetailReserveId2=new JSONArray();
    JSONArray getScheduleItemDetailReserveId3=new JSONArray();
    JSONArray getScheduleItemDetailReserveId4=new JSONArray();
    JSONArray getScheduleItemDetailReserveId5=new JSONArray();
    JSONArray getScheduleItemDetailReserveId6=new JSONArray();
    JSONArray getScheduleItemDetailReserveId7=new JSONArray();


    //2个会员约7个课次的14个约课id，后面清除数据要用
    String getScheduleItemDetailReserveId11;
    String getScheduleItemDetailReserveId22;
    String getScheduleItemDetailReserveId33;
    String getScheduleItemDetailReserveId44;
    String getScheduleItemDetailReserveId55;
    String getScheduleItemDetailReserveId66;
    String getScheduleItemDetailReserveId77;

    String getScheduleItemDetailReserveId111;
    String getScheduleItemDetailReserveId222;
    String getScheduleItemDetailReserveId333;
    String getScheduleItemDetailReserveId444;
    String getScheduleItemDetailReserveId555;
    String getScheduleItemDetailReserveId666;
    String getScheduleItemDetailReserveId777;

    String cardId;

    JSONArray memberInfo1 = new JSONArray();




    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Reserve,"API_batchReserveGroup", LoginAccount.GYM_PROD, Terminal.B,"yff");
        super.beforeTest();
    }

    @Test(description = "批量预约团课")
    public void testBatchReserveGroup() {


        //因为是存量排好团课的数据去批量预约的，存量数据需要提前做的是：
             //创建一个课程：批量预约团课课程-禁用  必须是30分钟；创建两个会员：批量约团课会员1和批量约团课会员2；排好团课，用上述的课程排好一年的数据；人数上限必须是60（下面的筛选是59人以上，不是60会筛不出来的），时间必须是00.00-00.30，上课星期是：周一~周日；教练是：f昵称昵称昵称f昵称昵称昵称f昵称昵称昵称
        //注意：只能排一年的，只排到了来年2026-04-03的，后面记得重新排团课
        //注意：reserveMemberNum和planCheckBalance必须是1，超出太多会不够扣除，后面的校验也对不上


        //根据筛选条件拉取对应的课次  筛选条件：课程（存量课程：批量预约团课课程-禁用：（这个课程已经排好课是00.00-00.30  必须30分钟  人数上限必须是60人 下面筛的是59以上的 否则会筛不出来的））；
        //日期范围：本周；上课星期：周一到周日；上课时间范围：00.00-24.00；上课教练：f；剩余可约人数：59人及以上；  预期：可以拉取7个课次
        JSONObject getCanReserveGroupScheduleList = reserveTools.getCanReserveGroupScheduleList(courseId, "1796482784551211010", TimeUtils.getWeekFirstTime(),TimeUtils.getWeekLastTime(), 59, 0, 1440);

        JSONObject getCanReserveGroupScheduleListResult = getCanReserveGroupScheduleList.getJSONObject("result");
        String  size =getCanReserveGroupScheduleListResult.getString("size");
//        Assert.assertEquals(size, 7, "筛选条件下的拉取课次数据应是7条");
        //对应的七个scheduleId
        JSONObject jsonObjectscheduleId1 = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(0);
        scheduleId1 = jsonObjectscheduleId1.getString("scheduleId");
        String startTime1 = jsonObjectscheduleId1.getString("startTime");

        JSONObject jsonObjectscheduleId2 = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(1);
        scheduleId2 = jsonObjectscheduleId2.getString("scheduleId");
        String startTime2 = jsonObjectscheduleId2.getString("startTime");

        JSONObject jsonObjectscheduleId3 = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(2);
        scheduleId3 = jsonObjectscheduleId3.getString("scheduleId");
        String startTime3 = jsonObjectscheduleId3.getString("startTime");

        JSONObject jsonObjectscheduleId4 = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(3);
        scheduleId4 = jsonObjectscheduleId4.getString("scheduleId");
        String startTime4 = jsonObjectscheduleId4.getString("startTime");

        JSONObject jsonObjectscheduleId5 = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(4);
        scheduleId5 = jsonObjectscheduleId5.getString("scheduleId");
        String startTime5 = jsonObjectscheduleId5.getString("startTime");

        JSONObject jsonObjectscheduleId6 = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(5);
        scheduleId6 = jsonObjectscheduleId6.getString("scheduleId");
        String startTime6 = jsonObjectscheduleId6.getString("startTime");

        JSONObject jsonObjectscheduleId7 = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(6);
        scheduleId7 = jsonObjectscheduleId7.getString("scheduleId");
        String startTime7 = jsonObjectscheduleId7.getString("startTime");


        String chiefCoachId = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(0).getString("chiefCoachId");
        String spanMinutes = getCanReserveGroupScheduleListResult.getJSONArray("records").getJSONObject(0).getString("spanMinutes");


        // 查询存量的学员没有则创建学员：批量约团课会员1和批量约团课会员2
        if (tools.commonSearch("批量约团课会员1-禁用", "NORMAL").getJSONArray("result").size() > 0) {
            memberId1 = tools.commonSearch("批量约团课会员1-禁用", "NORMAL").getJSONArray("result").getJSONObject(0).getString("id");
        } else if (tools.commonSearch("批量约团课会员1-禁用", "HISTORY").getJSONArray("result").size() > 0) {
            memberId1 = tools.commonSearch("批量约团课会员1-禁用", "HISTORY").getJSONArray("result").getJSONObject(0).getString("id");
        } else if (tools.commonSearch("批量约团课会员1-禁用", "POTENTIAL").getJSONArray("result").size() > 0) {
            memberId1 = tools.commonSearch("批量约团课会员1-禁用", "POTENTIAL").getJSONArray("result").getJSONObject(0).getString("id");
        } else {
            memberId1 = memberTools.create("批量约团课会员1-禁用", RandomStringUtil.randomMobile("203")).getString("result");
        }
        memberInfo1.add(memberId1);


        if (tools.commonSearch("批量约团课会员2-禁用", "NORMAL").getJSONArray("result").size() > 0) {
            memberId2 = tools.commonSearch("批量约团课会员2-禁用", "NORMAL").getJSONArray("result").getJSONObject(0).getString("id");
        } else if (tools.commonSearch("批量约团课会员2-禁用", "HISTORY").getJSONArray("result").size() > 0) {
            memberId2 = tools.commonSearch("批量约团课会员2-禁用", "HISTORY").getJSONArray("result").getJSONObject(0).getString("id");
        } else if (tools.commonSearch("批量约团课会员2-禁用", "POTENTIAL").getJSONArray("result").size() > 0) {
            memberId2 = tools.commonSearch("批量约团课会员2-禁用", "POTENTIAL").getJSONArray("result").getJSONObject(0).getString("id");
        } else {
            memberId2 = memberTools.create("批量约团课会员2-禁用", RandomStringUtil.randomMobile("203")).getString("result");
        }
        memberInfo1.add(memberId2);


        // 查询会员1是否有可用的会员卡，没有则购买

        //会员1：
        JSONArray listUserReservableBenefit = cardTools.listUserReservableBenefit(courseId, "GROUP_CLASS", "MEMBER", memberId1, TimeUtils.getTodayTime());
        if (listUserReservableBenefit.size() == 0) {
            // 购买适用的会员卡

            //获取会员卡信息
            //获取会员卡列表,没有则新建一个
            int cardTotal = Integer.parseInt(orderTools.fetchPageOfMemberCard("次卡不低于7次卡", "MEMBER_CARD").getJSONObject("result").getString("total"));
            if (cardTotal == 0) {
                cardId = cardTools.memberCardCreate("次卡不低于7次卡卡" + TimeUtils.getCurrentTime()).getString("result");
            }
            JSONObject memberCard = orderTools.fetchPageOfMemberCard("次卡不低于7次卡", "MEMBER_CARD");
            cardId = memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
            BigDecimal quantity = new BigDecimal(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("benefitList").getJSONObject(0).getString("balance"));
            float price = Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
            int validPeriod = Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //获取签单要用的卡快照id
            String latestSnapshotId = orderTools.fetchDetailById(cardId, xmAppApi.getLoginInfo().getBrandId(), xmAppApi.getLoginInfo().getStudioId(), xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //检查会员对该卡是否超出购买上限
            boolean limitResult = orderTools.checkAllowPurchase("MEMBER_CARD", cardId, memberId1, "1", xmAppApi.getLoginInfo().getBrandId(), xmAppApi.getLoginInfo().getStudioId(), xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }


            if (limitResult == true) {

                //创建签单订单
                JSONObject orderResult = orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, price / 2, "PURCHASE",
                        "MEMBER_CARD", memberId1, price - price / 2, price - price / 2, "1",true);
            }

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            listUserReservableBenefit = cardTools.listUserReservableBenefit(courseId, "GROUP_CLASS", "MEMBER", memberId1, TimeUtils.getTodayTime());
        }
        // 查询会员1权益
        String benefitId1 = listUserReservableBenefit.getJSONObject(0).getString("benefitId");
        String memberCardId1 = listUserReservableBenefit.getJSONObject(0).getString("memberCardId");
        memberInfo1.add(benefitId1);
        memberInfo1.add(memberCardId1);


        //会员2：
        JSONArray listUserReservableBenefit2 = cardTools.listUserReservableBenefit(courseId, "GROUP_CLASS", "MEMBER", memberId2, TimeUtils.getTodayTime());
        if (listUserReservableBenefit2.size() == 0) {
            // 购买适用的会员卡

            //获取会员卡信息
            //获取会员卡列表,没有则新建一个
            int cardTotal = Integer.parseInt(orderTools.fetchPageOfMemberCard("次卡不低于7次卡", "MEMBER_CARD").getJSONObject("result").getString("total"));
            if (cardTotal == 0) {
                cardId = cardTools.memberCardCreate("次卡不低于7次卡卡" + TimeUtils.getCurrentTime()).getString("result");
            }
            JSONObject memberCard = orderTools.fetchPageOfMemberCard("次卡不低于7次卡", "MEMBER_CARD");
            cardId = memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
            BigDecimal quantity = new BigDecimal(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("benefitList").getJSONObject(0).getString("balance"));
            float price = Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
            int validPeriod = Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //获取签单要用的卡快照id
            String latestSnapshotId = orderTools.fetchDetailById(cardId, xmAppApi.getLoginInfo().getBrandId(), xmAppApi.getLoginInfo().getStudioId(), xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //检查会员对该卡是否超出购买上限
            boolean limitResult = orderTools.checkAllowPurchase("MEMBER_CARD", cardId, memberId2, "1", xmAppApi.getLoginInfo().getBrandId(), xmAppApi.getLoginInfo().getStudioId(), xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }


            if (limitResult == true) {

                //创建签单订单
                JSONObject orderResult = orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, price / 2, "PURCHASE",
                        "MEMBER_CARD", memberId2, price - price / 2, price - price / 2, "1",true);
            }

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            listUserReservableBenefit2 = cardTools.listUserReservableBenefit(courseId, "GROUP_CLASS", "MEMBER", memberId2, TimeUtils.getTodayTime());
        }
        // 查询会员2权益
        String benefitId2 = listUserReservableBenefit2.getJSONObject(0).getString("benefitId");
        String memberCardId2 = listUserReservableBenefit2.getJSONObject(0).getString("memberCardId");
        memberInfo1.add(benefitId2);
        memberInfo1.add(memberCardId2);


        //批量预约检验，为true才可以继续批量预约
        boolean checkBatchReserve = Boolean.parseBoolean(reserveTools.checkBatchReserve(startTime7, 7, memberId1, benefitId1, 7, memberId2, benefitId2).getJSONObject("result").getString("success"));

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        if (checkBatchReserve == true) {

            //批量预约

            JSONObject batchReserveGroup = new JSONObject();
            batchReserveGroup.put("courseId", courseId);

            JSONArray jsonArray = new JSONArray();

            JSONObject member1 = new JSONObject();
            member1.put("memberId", memberId1);//第一个会员
            member1.put("benefitId", benefitId1);
            member1.put("reserveMemberNum", 1);//预约人数，注意只能用1 否则超出太多会不够扣的 这样下面的校验就会有问题
            member1.put("planCheckBalance", 1);//单课次消耗额度(每次消耗*预约人数)，每次消耗也必须是1，否则校验就对不上了

            JSONObject member2 = new JSONObject();
            member2.put("memberId", memberId2);//第二个会员
            member2.put("benefitId", benefitId2);
            member2.put("reserveMemberNum", 1);//预约人数，注意只能用1 否则超出太多会不够扣的 这样下面的校验就会有问题
            member2.put("planCheckBalance", 1);//单课次消耗额度(每次消耗*预约人数)，每次消耗也必须是1，否则校验就对不上了

            jsonArray.add(member1);
            jsonArray.add(member2);
            batchReserveGroup.put("memberInfoList", jsonArray);

            JSONArray jsonArray1 = new JSONArray();

            //第一个课次
            JSONObject jsonObject1 = new JSONObject();

            jsonObject1.put("chiefCoachId", chiefCoachId);
            jsonObject1.put("scheduleId", scheduleId1);
            jsonObject1.put("scheduleStartTime", startTime1);
            jsonObject1.put("spanMinutes", spanMinutes);
            JSONArray assistantCoachIds1 = new JSONArray();
            JSONArray venueAreaIds1 = new JSONArray();
            jsonObject1.put("assistantCoachIds", assistantCoachIds1);
            jsonObject1.put("venueAreaIds", venueAreaIds1);

            jsonArray1.add(jsonObject1);


            //第二个课次
            JSONObject jsonObject2 = new JSONObject();

            jsonObject2.put("chiefCoachId", chiefCoachId);
            jsonObject2.put("scheduleId", scheduleId2);
            jsonObject2.put("scheduleStartTime", startTime2);
            jsonObject2.put("spanMinutes", spanMinutes);
            JSONArray assistantCoachIds2 = new JSONArray();
            jsonObject2.put("assistantCoachIds", assistantCoachIds2);
            JSONArray venueAreaIds2 = new JSONArray();
            jsonObject2.put("venueAreaIds", venueAreaIds2);

            jsonArray1.add(jsonObject2);

            //第三个课次
            JSONObject jsonObject3 = new JSONObject();

            jsonObject3.put("chiefCoachId", chiefCoachId);
            jsonObject3.put("scheduleId", scheduleId3);
            jsonObject3.put("scheduleStartTime", startTime3);
            jsonObject3.put("spanMinutes", spanMinutes);
            JSONArray assistantCoachIds3 = new JSONArray();
            jsonObject3.put("assistantCoachIds", assistantCoachIds3);
            JSONArray venueAreaIds3 = new JSONArray();
            jsonObject3.put("venueAreaIds", venueAreaIds3);

            jsonArray1.add(jsonObject3);

            //第四个课次
            JSONObject jsonObject4 = new JSONObject();

            jsonObject4.put("chiefCoachId", chiefCoachId);
            jsonObject4.put("scheduleId", scheduleId4);
            jsonObject4.put("scheduleStartTime", startTime4);
            jsonObject4.put("spanMinutes", spanMinutes);
            JSONArray assistantCoachIds4 = new JSONArray();
            jsonObject4.put("assistantCoachIds", assistantCoachIds4);
            JSONArray venueAreaIds4 = new JSONArray();
            jsonObject4.put("venueAreaIds", venueAreaIds4);

            jsonArray1.add(jsonObject4);


            //第五个课次
            JSONObject jsonObject5 = new JSONObject();

            jsonObject5.put("chiefCoachId", chiefCoachId);
            jsonObject5.put("scheduleId", scheduleId5);
            jsonObject5.put("scheduleStartTime", startTime5);
            jsonObject5.put("spanMinutes", spanMinutes);
            JSONArray assistantCoachIds5 = new JSONArray();
            jsonObject5.put("assistantCoachIds", assistantCoachIds5);
            JSONArray venueAreaIds5 = new JSONArray();
            jsonObject5.put("venueAreaIds", venueAreaIds5);

            jsonArray1.add(jsonObject5);

            //第六个课次
            JSONObject jsonObject6 = new JSONObject();

            jsonObject6.put("chiefCoachId", chiefCoachId);
            jsonObject6.put("scheduleId", scheduleId6);
            jsonObject6.put("scheduleStartTime", startTime6);
            jsonObject6.put("spanMinutes", spanMinutes);
            JSONArray assistantCoachIds6 = new JSONArray();
            jsonObject6.put("assistantCoachIds", assistantCoachIds6);
            JSONArray venueAreaIds6 = new JSONArray();
            jsonObject6.put("venueAreaIds", venueAreaIds6);

            jsonArray1.add(jsonObject6);


            //第七个课次
            JSONObject jsonObject7 = new JSONObject();

            jsonObject7.put("chiefCoachId", chiefCoachId);
            jsonObject7.put("scheduleId", scheduleId7);
            jsonObject7.put("scheduleStartTime", startTime7);
            jsonObject7.put("spanMinutes", spanMinutes);
            JSONArray assistantCoachIds7 = new JSONArray();
            jsonObject7.put("assistantCoachIds", assistantCoachIds7);
            JSONArray venueAreaIds7 = new JSONArray();
            jsonObject7.put("venueAreaIds", venueAreaIds7);

            jsonArray1.add(jsonObject7);

            batchReserveGroup.put("reserveScheduleList", jsonArray1);
            batchReserveGroup.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            batchReserveGroup.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            batchReserveGroup.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

            xmAppApi.doRequest(RequestType.JSON, params, batchReserveGroup.toJSONString(), headers).assetsSuccess(true);
            JSONObject response = xmAppApi.getBodyInJSON();
            String success = response.getString("success");
            Assert.assertEquals(success, "true", "调用批量预约接口失败");

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }


            //拿到预约id-reserveid
            //第一个会员的7个课次的
            getScheduleItemDetailReserveId1 = groupScheduleTools.getScheduleItemDetail(scheduleId1).getJSONArray("reserveIds");
            getScheduleItemDetailReserveId11 = getScheduleItemDetailReserveId1.getString(0);
            getScheduleItemDetailReserveId111 = getScheduleItemDetailReserveId1.getString(1);

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            getScheduleItemDetailReserveId2 = groupScheduleTools.getScheduleItemDetail(scheduleId2).getJSONArray("reserveIds");
            getScheduleItemDetailReserveId22 = getScheduleItemDetailReserveId2.getString(0);
            getScheduleItemDetailReserveId222 = getScheduleItemDetailReserveId2.getString(1);

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            getScheduleItemDetailReserveId3 = groupScheduleTools.getScheduleItemDetail(scheduleId3).getJSONArray("reserveIds");
            getScheduleItemDetailReserveId33 = getScheduleItemDetailReserveId3.getString(0);
            getScheduleItemDetailReserveId333 = getScheduleItemDetailReserveId3.getString(1);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            getScheduleItemDetailReserveId4 = groupScheduleTools.getScheduleItemDetail(scheduleId4).getJSONArray("reserveIds");
            getScheduleItemDetailReserveId44 = getScheduleItemDetailReserveId4.getString(0);
            getScheduleItemDetailReserveId444 = getScheduleItemDetailReserveId4.getString(1);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            getScheduleItemDetailReserveId5 = groupScheduleTools.getScheduleItemDetail(scheduleId5).getJSONArray("reserveIds");
            getScheduleItemDetailReserveId55 = getScheduleItemDetailReserveId5.getString(0);
            getScheduleItemDetailReserveId555 = getScheduleItemDetailReserveId5.getString(1);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            getScheduleItemDetailReserveId6 = groupScheduleTools.getScheduleItemDetail(scheduleId6).getJSONArray("reserveIds");
            getScheduleItemDetailReserveId66 = getScheduleItemDetailReserveId6.getString(0);
            getScheduleItemDetailReserveId666 = getScheduleItemDetailReserveId6.getString(1);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            getScheduleItemDetailReserveId7 = groupScheduleTools.getScheduleItemDetail(scheduleId7).getJSONArray("reserveIds");
            getScheduleItemDetailReserveId77 = getScheduleItemDetailReserveId7.getString(0);
            getScheduleItemDetailReserveId777 = getScheduleItemDetailReserveId7.getString(1);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }


            // check 1： 会员的会员卡售卖记录详情中包含该批量约课记录锁定
            String lockedPurchaseBalance1 = cardTools.memberCardFindDetailById(memberCardId1).getJSONObject("result").getJSONObject("courseBenefit").getString("lockedPurchaseBalance");
            String lockedPurchaseBalance2 = cardTools.memberCardFindDetailById(memberCardId2).getJSONObject("result").getJSONObject("courseBenefit").getString("lockedPurchaseBalance");

            Assert.assertEquals(lockedPurchaseBalance1,"7.00","批量约预约人数为1的团课成功后，会员1的对应卡的锁定次数不是会员1预约1人1*拉取的课次数");
            Assert.assertEquals(lockedPurchaseBalance2,"7.00","批量约预约人数为1的团课成功后，会员2的对应卡的锁定次数不是会员2预约1人1*拉取的课次数");

            //check 2：会员的已约中有此7个课次
            JSONObject getPageByMember1 = reserveTools.getPageByMember1(courseId,"SUCCESS","UN_SIGNED","",TimeUtils.getWeekFirstTime(), TimeUtils.getWeekLastTime(), memberId1,"GROUP_CLASS");
            int total1=Integer.parseInt(getPageByMember1.getString("total"));

            JSONObject getPageByMember2 = reserveTools.getPageByMember1(courseId,"SUCCESS","UN_SIGNED","",TimeUtils.getWeekFirstTime(), TimeUtils.getWeekLastTime(), memberId2,"GROUP_CLASS");
            int total2=Integer.parseInt(getPageByMember2.getString("total"));

            Assert.assertEquals(total1,7,"批量约预约人数为1的团课成功后，会员1详情的团课预约记录不是预约人数1*拉取的课次数");
            Assert.assertEquals(total2,7,"批量约预约人数为1的团课成功后，会员2详情的团课预约记录不是预约人数1*拉取的课次数");





        }
        else {
            System.out.println("批量预约失败，会员的消耗方式不可用：所选卡可用次数不足或上课日期不在所选卡有效期内");
        }
        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

    }



    //check 3：校验每个课次中是否都包含了该会员
            @DataProvider
            public Object[][] dataProvider(){
                return new Object[][]{
                        {scheduleId1},//课次1
                        {scheduleId2},//课次2
                        {scheduleId3},//课次3
                        {scheduleId4},//课次4
                        {scheduleId5},//课次5
                        {scheduleId6},//课次6
                        {scheduleId7}//课次7
                };

            }
            @Test(description = "校验每个课次中是否都包含了该两个会员",dataProvider = "dataProvider",priority = 1)
            public void testCheckMemberReserve(String scheduleId){

            JSONObject getScheduleItemDetail = groupScheduleTools.getScheduleItemDetail(scheduleId);
            JSONArray memberReserveList = getScheduleItemDetail.getJSONArray("memberReserveList");

                JSONArray list=new JSONArray();
                list.add(memberId1);
                list.add(memberId2);

                boolean success = false;
                for (int i = 0; i < memberReserveList.size(); i++){
                    if(list.contains(memberReserveList.getJSONObject(i).getString("memberId"))){
                        success = true;
                }
            }
            Assert.assertTrue(success,"批量约团课后每个课次详情对应的学员不在课次中");
        }

        //清除数据：批量取消上面批量预约的课次
        @DataProvider
        public Object[][] dataProvider1(){
        return new Object[][]{
                //第一个会员的7个预约id
              {getScheduleItemDetailReserveId11,true},//课次1
              {getScheduleItemDetailReserveId22,true},//课次2
              {getScheduleItemDetailReserveId33,true},//课次3
              {getScheduleItemDetailReserveId44,true},//课次4
              {getScheduleItemDetailReserveId55,true},//课次5
              {getScheduleItemDetailReserveId66,true},//课次6
              {getScheduleItemDetailReserveId77,true},//课次7
                //第二个会员的7个预约id
              {getScheduleItemDetailReserveId111,true},//课次1
              {getScheduleItemDetailReserveId222,true},//课次2
              {getScheduleItemDetailReserveId333,true},//课次3
              {getScheduleItemDetailReserveId444,true},//课次4
              {getScheduleItemDetailReserveId555,true},//课次5
              {getScheduleItemDetailReserveId666,true},//课次6
              {getScheduleItemDetailReserveId777,true}//课次7
            };

    }
        @Test(description = "批量取消上面批量预约的课次",dataProvider = "dataProvider1",priority = 2)
        public void testCancelMemberReserve(String reserveId,boolean success){
        reserveTools.cancelMemberReserve(reserveId,success);
        }


}
