package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 删除课次（删除当前课次/删除当前及后续课次）
 *
 * @author adu
 * data 2024/6/30 17:02
 */

public class TestDelGroupScheduleItem extends UniversalDataScheduling {

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_delGroupScheduleItem", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }

    @Test(description = "删除当前课次")
    public void testDelCurrentGroupSchedule() {
        //获取下周四的课次ID(匹配到刚创建的规则ID)
        String scheduleId = groupScheduleTools.getTableDate(10, groupRuldId);
        //如果课次ID有值则继续走删除的case
        if (!StringUtils.isEmpty(scheduleId)) {
            JSONObject body1 = new JSONObject();
            body1.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            body1.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            body1.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            body1.put("applyRestRule", false);
            body1.put("scheduleId", scheduleId);
            xmAppApi.doRequest(RequestType.JSON, params, body1.toString(), headers);
            Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"));


            //删除成功后check 下周四课表是否有数据
            groupScheduleTools.getGroupScheduleTable(Long.valueOf(CommUtil.oneKeyGetNextWeekXDay(10)), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(4)), courseId);
            Long countA = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups").toJavaList(JSONObject.class).stream()
                    .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())
                    .filter(e -> e.getString("scheduleId").equals(scheduleId)).count();
            Assert.assertTrue(countA == 0, "删除课次后，课表中后端返回数据有问题，目前还能发现数据");

        }

    }

    @Test(description = "删除当前及后续课次", dependsOnMethods = {"testDelCurrentGroupSchedule"}, alwaysRun = true)
    public void testDelCurrentAndSubsequentGroupSchedule() {
        //获取下周三的课次ID(匹配到对应的规则ID)
        String scheduleIdsG = groupScheduleTools.getTableDate(9, groupRuldId);
        //如果课次ID有值则继续走删除的case
        if (!StringUtils.isEmpty(scheduleIdsG)) {
            JSONObject body = new JSONObject();
            body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            body.put("applyRestRule", true);
            body.put("scheduleId", scheduleIdsG);
            xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
            Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"));


            //删除成功后check 从下周三到下周日课表是否有数据
            groupScheduleTools.getGroupScheduleTable(Long.valueOf(CommUtil.oneKeyGetNextWeekXDay(9)), Long.valueOf(CommUtil.oneKeyGetNextWeekEndDay()), courseId);
            Long countB = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups").toJavaList(JSONObject.class).stream()
                    .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())
                    .filter(e -> null != e.getString("ruleId"))
                    .filter(e -> e.getString("ruleId").equals(groupRuldId)).count();
            Assert.assertTrue(countB == 0, "删除当前及后续课次后，课表中后端返回数据有问题，目前还能发现数据");


        }
    }

    @AfterTest(description = "删除此case创建的日程")
    public void delData() {
        List<String> ruleIdIds = new ArrayList<>();
        //查询这个case创建的相关日程
        JSONArray result = groupScheduleTools.getGroupRuleScheduleList(courseId, chiefCoachIdS);
        int count = result.size();
        if (count > 0) {//如果有数据，则获取对应日程ID
            ruleIdIds = result.stream().map(obj -> {
                        JSONObject ruldIdInfo = (JSONObject) obj;
                        return ruldIdInfo.getString("ruleId");
                    }
            ).collect(Collectors.toList());
        }
        if (ruleIdIds != null) {//获取到的日程ID不为空时，则逐个删除相关日程
            ruleIdIds.stream().forEach(ruleId -> {
                //删除对应日程
                groupScheduleTools.delGroupRuleSchedule(ruleId, true);

            });
        }


    }


}

    