package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.schedule.camp.SelectTargetTrainingCampAndGetInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author adu
 * data 2024/7/22 11:08
 */

public class TestDoSignCampOrder extends SelectTargetTrainingCampAndGetInfo {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @Resource(name = "tools")
    Tools tools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    String memberId = "";
    String memberId2 = "";
    String orderId = "";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_signOrderCamp", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "训练营活动详情-报名会员-给会员报名")
    public void testDoSignCampOrder() throws InterruptedException {
        //搜索目标会员
        String phone = "15558121569";
        memberId = trainingTools.searchTargerMember(phone);
        if (memberId.isEmpty()) {
            memberId = tools.create("阿杜", phone).getString("result");
        }
        //给会员报名
        trainingTools.doSignCampOrder(memberId, this.price, this.campId,"");
        Thread.sleep(1000);
        //报名成功后根据会员手机号，在报名会员列表搜索报名数据
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "给学员报名后，在报名列表没查询到数据");
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("state"), "PAID");
        String memberCardId = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("memberCardId");

        //查看报名详情
        trainingTools.getTrainingAccountDetailById(memberCardId);
        Assert.assertTrue(Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.trainingCampInfo.totalClassHour")).equals(this.totalClassHour));
        Assert.assertTrue(Double.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.trainingCampInfo.price")).equals(this.price));
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.owner.phone"), phone);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.trainingCampId"), this.campId);

        //删除训练营活动:删除失败
        trainingTools.delTrainingFail(this.campId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.code"),"TRAINING_CAMP_DELETE_FAILED");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.message"),"该训练营已有人报名，无法删除！");


        //报名详情-训练营报名退款
        trainingTools.refundCampOrder(memberId, this.price, memberCardId, this.totalClassHour);
        Thread.sleep(1000);


        //退单后再搜索报名记录check
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 0, "给学员退单后，在报名列表中还能查询到数据");
        Thread.sleep(2000);

        //退单后check训练营报名记录(入口：报名记录)：根据训练营，报名记录状态，来源
        List<String> cardState=new ArrayList<>();
        cardState.add("REFUNDED");
        trainingTools.searchTrainingAccountRecordsList(this.campId,"B_OFF_LINE",cardState);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.records").size()==1,"没有搜索到对应数据");
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.records").getJSONObject(0).getString("ownerId"),memberId);


        //报名记录中全局搜索-会员手机号-会员购买训练营的相关记录中check
        trainingTools.fetchUserTrainingCardList(memberId);
        //第一条数据就是上一步操作的退单账户信息
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").getJSONObject(0).getString("id"),memberCardId);
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").getJSONObject(0).getString("state"),"REFUNDED");

        //退单后再次给该学员报名，提示已经报过该训练营，就不能再报了
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());

        body.put("salesmanId", xmAppApi.getLoginInfo().getAdminId());
        body.put("operationTime", TimeUtils.getCurrentTime());
        body.put("objectId", RandomStringUtil.randomString(20));
        body.put("memberId", memberId);
        body.put("receivableAmount", this.price);

        JSONObject campInfo = new JSONObject();
        campInfo.put("campId", campId);
        body.put("camp", campInfo);
        JSONArray paymentWays = new JSONArray();
        JSONObject payObject = new JSONObject();
        payObject.put("amount", this.price);
        payObject.put("paymentWay", "1");
        payObject.put("voucherResourceIds", new JSONArray());
        body.put("paymentWays", paymentWays);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(false);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"), "签单失败，已报名该训练营无需重复操作");
    }

    @Test(description = "给学员报名训练营活动构造待支付订单",dependsOnMethods = {"testDoSignCampOrder"},alwaysRun = true)
    public void testUnpaidOrder() throws InterruptedException {
        //搜索目标会员
        String phone = "15658063769";
        memberId2 = trainingTools.searchTargerMember(phone);
        if (memberId2.isEmpty()) {
            memberId2 = tools.create("晨晨爸爸", phone).getString("result");
        }
       //报名接口做了重复调用限制，间隔3000秒，否则提示：调用过于频繁，请稍后重试
        Thread.sleep(4000);

        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());

        body.put("salesmanId", xmAppApi.getLoginInfo().getAdminId());
        body.put("operationTime", TimeUtils.getCurrentTime());
        body.put("objectId", RandomStringUtil.randomString(20));
        body.put("memberId", memberId2);
        body.put("receivableAmount", this.price);

        JSONObject campInfo = new JSONObject();
        campInfo.put("campId", this.campId);
        body.put("camp", campInfo);
        body.put("paymentWays", new JSONArray());//支付方式传空
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));

        orderId = XMJSONPath.readPath(xmAppApi.getApi_response(), "$.result");
        //报名成功后根据会员手机号，在报名会员列表搜索报名数据
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "给学员报名后，在报名列表没查询到数据");
        //check订单 待支付状态
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("state"), "WAITING");

        //操作取消订单
        orderTools.cancel(orderId);
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 0, "取消学员订单后，在报名列表中还能查询到数据");

    }


    @AfterTest(description = "删除此case创建的训练营活动-退单/取消订单后可以删除活动")
    public void delData() {
        if (!this.campId.isEmpty()) {
            trainingTools.deleteTraining(this.campId);
        }

    }


}

    