package com.xiaomai.cases.polar.coupon;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component("couponMinTools")
public class CouponMInTools extends XMBaseTest {
    /**
     * @param
     * @description:小程序查看我的优惠券
     * @author: yangjian
     * @param status 我的优惠券列表
     **/
    public JSONObject listMemberReceivedCoupon(String receiverId,String status, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_listMemberReceivedCoupon")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("receiverId", receiverId);
        jsonObject.put("status", status);//AVAILABLE待使用；USED已使用；EXPIRED已过期

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:首页-优惠券查看更多列表
     * @author: yangjian
     * @param id 优惠券id
     **/
    public JSONObject pageStudioCoupon(String id, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_pageStudioCoupon")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);
        List<String> ids = new ArrayList<>();
        ids.add(id);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 50);
        jsonObject.put("ids", ids);
        jsonObject.put("nameLike", "");
        jsonObject.put("status", "CLAIMABLE");
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:小程序主动领取优惠券
     * @author: yangjian
     * @param couponId 优惠券id
     * @param receiverId
     **/
    public JSONObject claim(String couponId,String receiverId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_claim")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("couponId", couponId);
        jsonObject.put("receiverId", receiverId);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:小程序优惠券详情
     * @author: yangjian
     * @param id 优惠券id
     **/
    public JSONObject coupon_get(String id, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_coupon_get")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", id);



        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:首页获取信息
     * @author: yangjian

     **/
    public JSONObject getPageConfig( DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_getPageConfig")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pageKey", "HOME");
        jsonObject.put("tenantId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("tenantType", "STUDIO");



        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }






}
