package com.xiaomai.cases.polar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.reserve.personal
 * @Author: xuyamei
 * @CreateTime: 2024-07-24  11:49
 * @Description: 批量设置常规可约时间
 * @Version: 1.0
 */
public class TestCreateBatchNormalDate extends BaseTestImpl {
    @Resource(name = "reserveTools")
    ReserveTools reserveTools;
    JSONArray coachIds = new JSONArray();


    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Reserve,"API_createBatchNormalDate", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testCreateBatchNormalDate(){

        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());

        // 获取教练列表
        JSONObject pageStudioPersonalCoach = reserveTools.pageStudioPersonalCoach("");
        int total = pageStudioPersonalCoach.getInteger("total");
        Random rand = new Random();
        // 随机取两个教练
        String coachedId1 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?10:total)).getString("id");
        coachIds.add(coachedId1);
        String coachedId2 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?10:total)).getString("id");
        if (coachedId1.equals(coachedId2)){
            coachedId2 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?9:total-1)).getString("id");
        }
        coachIds.add(coachedId2);

        body.put("coachIds", coachIds); // 员工id
        // 设置可约时间
        JSONArray normalTimeInfoRequests = new JSONArray();
        JSONObject infoRequests = new JSONObject();
        JSONArray timePeriodInfos = new JSONArray();
        // 三个时段 5:00-12:00 12:00-18:00 18:00-23:00
        int[] minuteOffset = {300,720,1080};
        int[] spanMinutes = {420,360,300};

        for (int i = 0; i < 3; i++){
            JSONObject timeInfo = new JSONObject();
            timeInfo.put("minuteOffset",minuteOffset[i]);
            timeInfo.put("spanMinutes",spanMinutes[i]);
            timePeriodInfos.add(timeInfo);
        }
        infoRequests.put("timePeriodInfos",timePeriodInfos);

        // 每星期
        String[] weekdays = {"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};
        infoRequests.put("weekdays",weekdays);
        normalTimeInfoRequests.add(infoRequests);
        body.put("normalTimeInfoRequests",normalTimeInfoRequests);
        // 批量设置可约时间
        xmAppApi.doRequest(RequestType.JSON,params, body.toString(), headers).assetsSuccess(true);
        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < coachIds.size(); i++){
            JSONArray personalCoachTime = reserveTools.getPersonalCoachTime(coachIds.getString(i),"normalTimeVOS");
            // 校验每周重复的可约时间
            Assert.assertEquals(timePeriodInfos.toString(),personalCoachTime.getJSONObject(0).getJSONArray("timePeriodInfos").toString(),"每周重复的可约时间请求结果与实际结果不一样");
            JSONArray weekDays = new JSONArray(Arrays.asList(weekdays));
            Assert.assertEquals(weekDays.toString(),personalCoachTime.getJSONObject(0).getJSONArray("weekdays").toString(),"每周重复的周请求结果与实际结果不一样");
        }

    }

    @Test(description = "将设置的值清空",priority = 1)
    public void testCreateBatchNormalDate_clear(){
        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        JSONArray normalTimeInfoRequests = new JSONArray();
        body.put("normalTimeInfoRequests",normalTimeInfoRequests);
        body.put("coachIds", coachIds); // 员工id

        xmAppApi.doRequest(RequestType.JSON,params, body.toString(), headers).assetsSuccess(true);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < coachIds.size(); i++){
            JSONArray personalCoachTime = reserveTools.getPersonalCoachTime(coachIds.getString(i),"normalTimeVOS");
            // 校验每周重复的可约时间
            Assert.assertTrue(personalCoachTime.size()==0,"清空数据后还能查询到数据");
        }

    }


}
