package com.xiaomai.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import org.springframework.util.StringUtils;

/**
 * 简单封装 根据 jsonPath 获取对象
 */
public class XMJSONPath {
    public static String readPath(String jsonString, String path) {
        if (StringUtils.isEmpty(jsonString)) {
            return "";
        } else {
            try {
                Object object = JSONPath.read(jsonString, path);
                if (null == object) {
                    return "";
                } else {
                    return object.toString();
                }
            } catch (Exception e) {
                return "";
            }

        }
    }

    public static String readPath(JSONObject json, String path) {
        if (null == json) {
            return "";
        } else {
            try {
                Object object = JSONPath.read(json.toJSONString(), path);
                if (null == object) {
                    return "";
                } else {
                    return object.toString();
                }
            } catch (Exception e) {
                return "";
            }

        }
    }

    public static JSONObject getJSONObjectByReadPath(String jsonString, String path) {
        if (StringUtils.isEmpty(jsonString)) {
            return null;
        } else {
            try {
                Object object = JSONPath.read(jsonString, path);
                if (null == object) {
                    return null;
                } else {
                    return (JSONObject) object;
                }
            } catch (Exception e) {
                return null;
            }

        }
    }

    public static JSONArray getJSONArrayByReadPath(String jsonString, String path) {
        if (StringUtils.isEmpty(jsonString)) {
            return null;
        } else {
            try {
                Object object = JSONPath.read(jsonString, path);
                if (null == object) {
                    return null;
                } else {
                    return (JSONArray) object;
                }
            } catch (Exception e) {
                return null;
            }
        }
    }

    public static JSONObject getJSONObjectByReadPath(JSONObject json, String path) {
        if (null == json) {
            return null;
        } else {
            try {
                Object object = JSONPath.read(json.toJSONString(), path);
                if (null == object) {
                    return null;
                } else {
                    return (JSONObject) object;
                }
            } catch (Exception e) {
                return null;
            }

        }
    }

    public static JSONArray getJSONArrayByReadPath(JSONObject json, String path) {
        if (null == json) {
            return null;
        } else {
            try {
                Object object = JSONPath.read(json.toJSONString(), path);
                if (null == object) {
                    return null;
                } else {
                    return (JSONArray) object;
                }
            } catch (Exception e) {
                return null;
            }
        }
    }

    public static JSONObject getJSONObjectByKeyValue(JSONArray jsonArray, String key, String value) {
        if (null == jsonArray) {
            return null;
        } else {
            jsonArray.stream().filter(o -> {
                JSONObject jsonObject = (JSONObject) o;
                return jsonObject.getString(key).equals(value) ? true : false;
            });
            return jsonArray.getJSONObject(0);

        }
    }

}
