package com.xiaomai.basetest;

import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeClass;

/**
 * @Auther: pdd
 * @Date: 2020/11/24/21:04
 * @Description: 抽取公共继承工具类可用
 */
public abstract class BaseTestImpl extends XMBaseTest implements BaseTestInterface {
    private String apiModuleName;
    private String apiName;
    private String loginUser;
    private String terminal;
    private String caseOwner;

    @Override
    public String getApiModuleName() {
        return this.apiModuleName;
    }

    /**
     * @Description: 每次必重写方法
     * @Author: pdd
     * @Date: 2020/11/26/11:20
     */
    @Override
    public String getApiName() {
        return this.apiName;
    }

    @Override
    public String getLoginUser() {
        return this.loginUser;
    }

    @Override
    public String getTerminal() {
        return this.terminal;
    }

    @Override
    public String getCaseOwner() {
        return this.caseOwner;
    }

    public void setTestInfo(String apiModuleName, String loginUser, String terminal, String caseOwner) {
        this.apiModuleName = apiModuleName;
        this.loginUser = loginUser;
        this.terminal = terminal;
        this.caseOwner = caseOwner;
    }

    public void setTestInfo(String apiModuleName, String apiName, String loginUser, String terminal, String caseOwner) {
        this.apiModuleName = apiModuleName;
        this.loginUser = loginUser;
        this.terminal = terminal;
        this.caseOwner = caseOwner;
        this.apiName = apiName;
    }


    @BeforeClass
    @Override
    public void beforeTest() {
        xmAppApi.setApiModule(getApiModuleName())
                .setApiName(getApiName())
                .setLoginUser(getLoginUser())
                .setTerminal(getTerminal());
        dal.setCase_owner(getCaseOwner());
        super.beforeTest();
    }

    @Override
    public void businessData() { }

}
