package com.xiaomai.cases.polar.reserve;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.reserve
 * @Author: xuyamei
 * @CreateTime: 2024-06-12  08:36
 * @Description: 预约工具类
 * @Version: 1.0
 */

@Component("reserveTools")
public class ReserveTools extends XMBaseTest {

    /**
     * @description: 添加预约
     * @author: xuyamei
     * @date:  2024/6/12 09:36
     * @param areaId 场地
     * @param assistantCoachId 助教id
     * @param benefitId 会员卡权益id
     * @param chiefCoachId 主教id
     * @param memberId 会员id
     * @param reserveMemberNum 预约人数
     * @param scheduleId    课次id
     * @param scheduleStartTime 上课时间
     * @param dataUserInfos 登录用户信息
     * @return: java.lang.String 预约id
     **/
    public String addReserve(String areaId,String assistantCoachId,String benefitId,String chiefCoachId,String memberId,int reserveMemberNum,String scheduleId,long scheduleStartTime,boolean success,DataUserInfo...dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_addReserve")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        JSONArray areaIds = new JSONArray(); // 场地,私教约课会用到
        if (!areaId.equals("")){
            areaIds.add(areaId);
        }
        body.put("areaIds",areaIds);
        JSONArray coachIds = new JSONArray(); // 助教Ids
        if (!assistantCoachId.equals("")){
            coachIds.add(assistantCoachId);
        }
        body.put("assistantCoachIds",coachIds);
        body.put("benefitId",benefitId); //会员卡权益Id
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("chiefCoachId", chiefCoachId); // 主教id
        body.put("memberId", memberId); // 会员id
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("planCheckBalance", 1); // 计划扣除额度
        body.put("reserveMemberNum", reserveMemberNum); // 预约人数
        body.put("scheduleId", scheduleId); // 课次id
        body.put("scheduleStartTime", scheduleStartTime); // 课次id
        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(success);
        if (success){
            return dataApi.getBodyInJSON().getJSONObject("result").getString("reserveId");
        }
        return dataApi.getBodyInJSON().toString();

    }

    /**
     * @description:获取会员预约记录列表
     * @author: xuyamei
     * @date:  2024/6/12 15:26
     * @param courseId 课程id
     * @param reserveStateSet 预约状态
     * @param signState 签到状态
     * @param coachId 教练id
     * @param scheduleStartTime 上课开始时间
     * @param scheduleEndDate 上课结束时间
     * @param memberId  会员id
     * @param courseType 课程类型 GROUP_CLASS：团课
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONArray getPageByMember(String courseId,String reserveStateSet,String signState,String coachId,Long scheduleStartTime,long scheduleEndDate,String memberId,String courseType,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_getPageByMember")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",20);
        if (!courseId.equals("")){
            body.put("courseId",courseId);
        }
        if (!reserveStateSet.equals("")){
            JSONArray reserveState = new JSONArray();
            reserveState.add(reserveStateSet);
            body.put("reserveStateSet",reserveState);
        }
        if (!signState.equals("")){
            body.put("signInState",signState);
        }
        if (!coachId.equals("")){
            body.put("coachId",coachId);
        }
        if (scheduleStartTime != null){
            body.put("scheduleStartTime",scheduleStartTime);
            body.put("scheduleEndDate",scheduleEndDate);
        }
        if(!memberId.equals("")){
            body.put("memberId",memberId);
        }
        body.put("courseType",courseType);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");
    }

    /**
     * @description:预约记录列表
     * @author: xuyamei
     * @date:  2024/6/13 11:42
     * @param courseId 课程id
     * @param reserveState 预约状态
     * @param signState 签到状态
     * @param coachId 教练id
     * @param scheduleStartTime 上课开始时间
     * @param scheduleEndDate 上课结束时间
     * @param memberId  会员id
     * @param courseType 课程类型 GROUP_CLASS：团课
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getPageByStudio(String courseId,String reserveState,String signState,String coachId,Long scheduleStartTime,Long scheduleEndDate,String memberId,String courseType,DataUserInfo...dataUserInfos){
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_getPageByStudio")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);


        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",20);
        if (!courseId.equals("")){
            body.put("courseId",courseId);
        }
        if (!reserveState.equals("")){
            body.put("reserveState",reserveState);
        }
        if (!signState.equals("")){
            body.put("signInState",signState);
        }
        if (!coachId.equals("")){
            body.put("coachId",coachId);
        }
        if (scheduleStartTime != null){
            body.put("scheduleStartTime",scheduleStartTime);
            body.put("scheduleEndDate",scheduleEndDate);
        }
        if(!memberId.equals("")){
            body.put("memberId",memberId);
        }
        body.put("courseType",courseType);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");
    }


     /**
     * @description:根据id获取预约记录信息
     * @author: xuyamei
     * @date:  2024/6/13 11:51
     * @param reserveId: 预约id
     * @return:
     **/
    public JSONObject getDetailById(String reserveId,DataUserInfo...dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_getDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        body.put("reserveId",reserveId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    public void cancelMemberReserve(String reserveId,boolean success){
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_cancel")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONArray reserveIds = new JSONArray();
        reserveIds.add(reserveId);
        JSONObject body = new JSONObject();
        body.put("reserveIds",reserveIds);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(success);
    }
}
