package com.xiaomai.cases.polar.data;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.sql.Time;

public class TestCamDataTrend extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_camDatatrend")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "上课数据-趋势分析-次数")
    public void testcamDatatrend() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","DAY");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("metric","CLASS_SESSION_NUMBER");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-趋势分析-消耗金额")
    public void testcamDatatrend1() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","DAY");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("metric","TOTAL_COST");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-趋势分析-上课人次")
    public void testcamDatatrend2() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","DAY");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("metric","TOTAL_NUMBER");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "上课数据-趋势分析-上课时长")
    public void testcamDatatrend3() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateType","DAY");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("metric","CLASS_HOUR");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }

}
