package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.Date;

/**
 * @author adu
 * data 2024/8/1 11:09
 */

public class TestEditCurrentAndSubsequentGroupSchedule extends UniversalDataScheduling{
    public static Date now = new Date();
    String newGroupRuldId="";


    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_editGroupSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }

    @Test(description = "编辑当前及后续课次")
    public void testEditCurrentAndSubsequentGroupSchedule() {
        //获取下周二的课次ID(匹配到刚创建的规则ID)
        String scheduleId = groupScheduleTools.getTableDate(8, groupRuldId);
        //如果课次ID有值则继续走编辑的case
        if (!StringUtils.isEmpty(scheduleId)) {
            {
                JSONObject body = new JSONObject();
                body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                body.put("applyRestRule", true);//改的时日程当前及后续
                body.put("scheduleId", scheduleId);
                //获取下周二某个时间点的开始时间戳
                String startStamp1 = CommUtil.getWholeHourTimeStamp(8, "13:00");
                body.put("startTime", startStamp1);

                body.put("chiefCoachId", chiefCoachIdS);
                body.put("minMemberNum", 6);//修改开课人数
                body.put("maxMemberNum", 999);
                body.put("venueAreaIds", venueAreaIds);
                body.put("assistCoachIds", new ArrayList<>());//修改教练
                body.put("spanMinutes", 50);
                body.put("force", true);//有冲突时忽略冲突
                //body.put("retainBooking", true);//保留学员预约，无改动到时间，教练，场地则不需要传此字段

                xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
                Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));

                try {
                    Thread.sleep(3000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                //编辑成功后check对应课次详情修改内容是否同步成功
                checkData(scheduleId, startStamp1);

                //通过课次详情，活动课次对应的ruldId
                newGroupRuldId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.ruleId");


                //查看下周三课次是否同步被修改
                String scheduleIdX = groupScheduleTools.getTableDate(9, newGroupRuldId);
                String startStamp2 = CommUtil.getWholeHourTimeStamp(9, "13:00");
                if (!StringUtils.isEmpty(scheduleIdX)) {
                    //编辑成功后check同规则中下周三课次详情修改内容是否同步成功
                    checkData(scheduleIdX, startStamp2);

                }


            }
            //获取下周一的课次ID，查看下周一课次是否还是原来的（没被修改，还是原来的规则）
            String scheduleId1 = groupScheduleTools.getTableDate(7, groupRuldId);
            String startStamp3 = CommUtil.getWholeHourTimeStamp(7, "13:00");
            if (!StringUtils.isEmpty(scheduleId1)) {
                //编辑成功后check同规则中下周一课次详情
                groupScheduleTools.getScheduleItemDetail(scheduleId1);
                String detailResult1 = dataApi.getApi_response();
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.chiefCoachId"), chiefCoachIdS);
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.minMemberNum"), "2");
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.maxMemberNum"), "999");
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.startTime"), startStamp3);
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.assistCoachIds").containsAll(assistCoachIdS), "助教无修改，但是却变动了");
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.venueAreaIds").containsAll(venueAreaIds), "场地无修改，但是却变动了");

            }

        }
    }


    /**
     * 编辑后通过查看课次详情check数据是否同步被修改
     * @param scheduleId
     */
    public void checkData (String scheduleId, String tiemStamp){
        groupScheduleTools.getScheduleItemDetail(scheduleId);
        String detailResult1 = dataApi.getApi_response();
        Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.chiefCoachId"), chiefCoachIdS);
        Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.minMemberNum"), "6");
        Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.maxMemberNum"), "999");
        Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.startTime"), tiemStamp);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.assistCoachIds").size() == 0, "助教修改后（置空）没生效");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.venueAreaIds").containsAll(venueAreaIds), "场地无修改，但是却变动了");

    }

    @AfterTest(description = "删除此case创建的日程")
    public void delData () {

        if (!StringUtils.isEmpty(groupRuldId)) {//获取到的日程ID不为空时，则逐个删除相关日程
            //删除对应原日程
            groupScheduleTools.delGroupRuleSchedule(groupRuldId, true);
        }

        if (!StringUtils.isEmpty(newGroupRuldId)) {
            //删除编辑当前及后续生成的新规则
            groupScheduleTools.delGroupRuleSchedule(newGroupRuldId, true);
        }


    }
}

    