package com.xiaomai.cases.polar.setting.courseCategory;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.courseCategory
 * @Author: xuyamei
 * @CreateTime: 2024-04-29  20:02
 * @Description: 编辑课程分类
 * @Version: 1.0
 */
public class TestEditCourseCategory extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;

    private String categoryId;
    @BeforeClass
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_editCourseCategory", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test(description = "创建课程分类 --> 编辑课程分类 --> 查询课程分类")
    public void testEditCourseCategory() {
        String name = "新建课程分类"+ TimeUtils.getCurrentTime();
        // 创建课程分类
        categoryId = courseCategoryTools.createCourseCategory(name);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        name = name+"_编辑";
        // 编辑课程分类
        JSONObject body = new JSONObject();
        body.put("categoryId",categoryId);
        body.put("categoryName",name);
        body.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取课程分类详情
        JSONArray detailPage = courseCategoryTools.getCourseCategoryDetailPage(0).getJSONObject("result").getJSONArray("records");

        for (int i = 0; i < detailPage.size(); i++){
            if (detailPage.getJSONObject(i).getString("id").equals(categoryId)){
                String operatorId = detailPage.getJSONObject(0).getString("lastOperatorId");  // 最后操作人
                String categoryName = detailPage.getJSONObject(0).getString("categoryName"); // 课程分类名称
                // 校验编辑后的课程分类名称及操作人
                Assert.assertEquals(operatorId.equals(xmAppApi.getLoginInfo().getAdminId()) && categoryName.equals(name),true,"编辑的课程分类与查询后的不一致");
                break;
            }
        }

    }

    @Test(description = "清除增量数据",priority = 1)
    public void del(){
        boolean flag = courseCategoryTools.canModifyCourseCategory(categoryId,true);
        if (flag){
            courseCategoryTools.deleteCourseCategory(categoryId);

        }
    }
}
