package com.xiaomai.cases.polar.charts;

import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestMinfetchMemberRankList extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Charts)
                .setApiName("API_fetchMemberRankList")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    DataUserInfo info = new DataUserInfo();
    ChartsTools chartsTools =new ChartsTools();
    ChartsMinTools chartsMinTools = new ChartsMinTools();
    UserTools userTools = new UserTools();
    @Test(description = "小程序会员排榜榜")
    public void testJoinActivity()  {

        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);

        String reward ="{\"items\":[{\"aspect\":\"\",\"type\":\"TEXT\",\"content\":\"小程序自动化奖励规则\"}]}";
        chartsTools.memberRankListsaveRule("YES","YES",reward,"1","月榜自动化","1","季榜自动化","1","年榜自动化",info);//端设置季度、年榜
        chartsMinTools.findRuleMin();//小程序查看排行榜规则
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.openSeasonRank"), "YES", "季度榜未开启");//断言季度榜开启
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.seasonRankThreshold"), "1", "季度榜未开启");//断言季度榜上榜条件为1
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.openYearRank"), "YES", "年度榜未开启");//断言年度榜开启
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.yearRankThreshold"), "1", "季度榜未开启");//断言年度榜上榜条件为1

        chartsMinTools.fetchMemberRankList("YEAR");//查看年榜
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].member.id"), "1805435813468483586", "年榜第一名非目标");//C端自动化会员为第一名，刷新5分钟问题
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].member.resourceId"), "1", "年榜第一名非目标");

        String memberId = userTools.getMemberInfo().getString("memberId");
        chartsMinTools.fetchOneMemberRank("MONTH",memberId, TimeUtils.getMonthFristDay(),TimeUtils.getMonthLastDay());//查询当前登陆账号排行
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.member.id"), memberId, "查询非目标排榜");//断言查询会员
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.rankOrder"), "1", "目标非第一名");//断言会员为第一名
        String rankOrder=XMJSONPath.readPath(dataApi.getApi_response(),"$.result.rankOrder");//排行名次
        String checkInCount=XMJSONPath.readPath(dataApi.getApi_response(),"$.result.checkInCount");//获取上课节数


        chartsMinTools.getShareDetail(memberId,"MONTH",rankOrder,checkInCount);


    }
}
