package com.xiaomai.cases.polar.course;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;

import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;


/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-04-23  14:15
 * @Description: 创建私教课程
 * @Version: 1.0
 */
public class TestCreatePersonalCourse extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;

    private JSONArray courseIds = new JSONArray();

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Course, "API_personalCreate", LoginAccount.GYM_PROD, Terminal.B, "xym");
        super.beforeTest();
    }

    @DataProvider()
    public Object[][] data(){
        return new Object[][]{
                {"1对多","ONE_TO_MANY"}, // 1对多
                {"1对1","ONE_TO_ONE"}, // 1对1
        };
    }
    @Test(dataProvider = "data")
    public void testCreatePersonalCourse(String name,String sizeType) {
        // 获取课程分类
        String categoryId = courseCategoryTools.getCourseCategoryPage("私教课分类"+ TimeUtils.getCurrentTime());

        // 新建课程参数
        JSONObject body = new JSONObject();
        String courseName = name + "私教课程"+ TimeUtils.getCurrentTime();
        body.put("courseName", courseName);
        body.put("duration", 60);      // 时长
        body.put("difficulty", 3);     // 难度
        body.put("color", "#AACF53");
        body.put("coverId", "0");
        body.put("timeUnit", "MINUTE");
        body.put("categoryId", categoryId);  // 课程分类id
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("sourceId", xmAppApi.getLoginInfo().getStudioId());  // 来源：场馆、品牌
        body.put("sourceType", "STUDIO");  // 来源类型：场馆、品牌
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());  // 品牌
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("sizeType", sizeType);  // 私教模式
        body.put("allArea", false); // 场地
        JSONArray coachIds = new JSONArray();
        coachIds.add(xmAppApi.getLoginInfo().getAdminId());
        body.put("coachIds", coachIds);
        if (sizeType.equals("ONE_TO_MANY")){
            body.put("capacity", 2); // 课容量
            body.put("minCapacity", 1); // 开课人数
        }

        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        String courseId = xmAppApi.getBodyInJSON().getString("result");
        courseIds.add(courseId);

        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // check 1：查询私教课程列表
        String total = courseTools.getPersonalPage("ON",0,courseName,categoryId,sizeType,"").getString("total");
        Assert.assertEquals(total,"1","新建之后私教列表没有找到相关数据");

        // check 2: 查看课程详情是否与新建内容一致
        JSONObject courseDetail = courseTools.getCourseDetail(courseId);
        String[] keys = {"courseName","duration","difficulty","color","coverId","timeUnit","categoryId","sourceId","sourceType","brandId","sizeType","allArea","capacity","minCapacity"};
        String[] values = {courseName,"60","3","#AACF53","0","MINUTE",categoryId,xmAppApi.getLoginInfo().getStudioId(),"STUDIO",xmAppApi.getLoginInfo().getBrandId(),sizeType,"false","2","1"};
        for (int i = 0; i < keys.length; i++) {
            String result = values[i];
            // 1对1的容量为1
            if (sizeType.equals("ONE_TO_ONE") && keys[i].equals("capacity")){
                result = "1";
            }
            Assert.assertEquals(courseDetail.getString(keys[i]),result,"新建之后课程详情与新建内容不一致");
        }

    }

    @Test(description = "清除增量数据",priority = 1)
    public void del(){
        // 删除课程数据
       for (int i = 0; i < courseIds.size(); i++){
            courseTools.modifyCourseStatus(courseIds.getString(i),"DELETE",false);
       }
    }
}
