package com.xiaomai.cases.polar.entry;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.export.ExportTool;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;


import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;



public class TestMemberEntryExport extends XMBaseTest {


    @BeforeMethod
    public void beforeTest(){


        xmAppApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_memberEntry_export")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "入场记录导出")
    public void testMemberEntryExport(){

        ExportTool exportTool = new ExportTool();

        int before = Integer.parseInt(XMJSONPath.readPath(exportTool.pageStudioExportRecord(), "$.result.total"));

        JSONObject object = new JSONObject();
        object.put("entryType",null);
        object.put("startTime",TimeUtils.getBeforeDayDate(30));
        object.put("endTime", TimeUtils.getTodayEndTime());
        object.put("size",20);
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        int after = Integer.parseInt(XMJSONPath.readPath(exportTool.pageStudioExportRecord(), "$.result.total"));
        Assert.assertEquals(after,before+1);


    }

}
