package com.xiaomai.cases.polar.eventRegistration;

import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestDel extends XMBaseTest {


    @Resource(name = "EventRegistrationTools")
    EventRegistrationTools EventRegistrationTools;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Registration)
                .setApiName("API_deleteById")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "删除活动报名")
    public void testDel() {


        String activityName = "自动化" + RandomStringUtil.randomString(5);//活动名称
        String activityName1 = "自动化编辑" + RandomStringUtil.randomString(5);//活动名称

        int before1 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.getStudioActivityPage("UNPUBLISHED"), "$.result.total"));//未发布-初始活动条数
        int before2 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.getStudioActivityPage("PROCESSING"), "$.result.total"));//报名中-初始活动条数
        EventRegistrationTools.create(activityName,false, TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),TimeUtils.getToDayTime(23,00));//创建活动
        String activityId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//创建活动后，拿活动id

        EventRegistrationTools.sellableActivity_getStudioActivityById(activityId);
        String skuId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result.skuItems[0].id");
        EventRegistrationTools.edit(activityName1,false, TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),TimeUtils.getToDayTime(23,00),activityId,skuId);//编辑活动，修改活动名称


        int after1 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.getStudioActivityPage("UNPUBLISHED"), "$.result.total"));//创建活动后，未发布活动条数
        Assert.assertEquals(after1,before1+1);//创建未发布活动后，活动数+1


        EventRegistrationTools.SearchActivity(activityName1);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.total"), "1", "未搜索到目标活动");


        EventRegistrationTools.sellableActivity_publish(activityId);//发布活动
        int after2 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.getStudioActivityPage("PROCESSING"), "$.result.total"));//发布活动后，进行中的活动条数
        Assert.assertEquals(after2,before2+1);//创建未发布活动后，活动数+1



        EventRegistrationTools.sellableActivityInvalid(activityId);//失效活动
        EventRegistrationTools.sellableActivity_getStudioActivityById(activityId);//查看失效活动
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "ABNORMAL", "未失效活动成功");//断言活动详情返回状态为已失效


        EventRegistrationTools.deleteById(activityId);//删除活动
        int after3 = Integer.parseInt(XMJSONPath.readPath(EventRegistrationTools.getStudioActivityPage("PROCESSING"), "$.result.total"));//删除活动后，进行中的活动条数
        Assert.assertEquals(after3,before2);//进行中的活动-1，和初始一样




    }
}
