package com.xiaomai.cases.polar.reserve.group;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Random;


public class TestMemberReserveDiscardSignIn extends XMBaseTest {

    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;

    @Resource(name = "reserveTools")
    ReserveTools reserveTools;

    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;

    MemberTools memberTools = new MemberTools();

    OrderTools orderTools = new OrderTools();
    CardTools cardTools = new CardTools();

    Tools tools = new Tools();

    String todayStartTimeTamp = CommUtil.oneKeyGetAddDay(-1);
    Long scheduleEndTime = TimeUtils.getTodayEndTime(-1);

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_discardSignIn")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "撤销签到")
    public void testMemberReserveDiscardSignIn(){

        String reserveId="1904005941288620033";
        reserveTools.signIn(true,reserveId,false);//签到
        reserveTools.getDetailById(reserveId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.signInState"), "SIGNED", "签到失败");//断言目标签到成功
        reserveTools.memberReserve_discardSignIn(reserveId);//撤销签到
        reserveTools.getDetailById(reserveId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.signInState"), "UN_SIGNED", "撤销签到失败");//断言目标预约记录未签到






    }





}
