package com.xiaomai.cases.polar.setting.venue;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.export.ExportTool;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;

import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import javax.annotation.Resource;

public class TestVenueBookingRecordExport extends XMBaseTest {


    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_venueBookingRecord_export")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();

    }
    @Test(description = "场地预约-约场记录-导出")
    public void testvenueBookingRecordExport() {

        ExportTool exportTool = new ExportTool();

        int before = Integer.parseInt(XMJSONPath.readPath(exportTool.pageStudioExportRecord(), "$.result.total"));

        JSONObject object = new JSONObject();
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        String id =XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//导出任务id

        int after = Integer.parseInt(XMJSONPath.readPath(exportTool.pageStudioExportRecord(), "$.result.total"));
        Assert.assertEquals(after,before+1);



    }
}
