package com.xiaomai.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.testng.Assert;

import java.util.Properties;

/**获取requestParamter
 * @Author laosy
 * @Date 2020/11/17  20:22
 */
public class ParamterTemplate {
    public static JSONObject getApiParamterTemplate(String apiModule, String apiName) {
        Assert.assertNotNull(apiModule, "必要的api信息不存在！");
        Properties prop = CommUtil.getconfig();
        JsonAndFile fileHandle = new JsonAndFile();

        String apiModulePath = prop.getProperty(apiModule);
        // 获取接口模块参数
        String fileParam = fileHandle.readTxtFile(System.getProperty("user.dir") + apiModulePath);
        Assert.assertNotNull(fileParam, "必要的API模块信息未找到，请检查api模块文件路径！");

        JSONObject api = (JSONObject) JSON.parseObject(fileParam).get(apiName);
        Assert.assertNotNull(api, "必要的API接口信息未找到，请检查apiName信息！");
        if (api.containsKey("requestParamter")) {
            /* executionApi.setRequestParamterTemplate(api.getString("requestParamter"));*/
        }

        return api.getJSONObject("requestParamter");
    }
}
