from src.pageobject.mainpage import MainPage
from selenium.webdriver.common.by import By


# 主页面
class WhiteBoardPage(MainPage):
    # 元素集
    # 切换白板标签
    white_board = (By.XPATH, """//div[text()="白板"]""")
    # 添加白板按钮
    add_white_board = (By.XPATH, """//span[text()=" 添加白板"]""")
    # 打开白板
    open_white_board = (By.XPATH, """//span[@class="name oneLineText"]""")
    # iframe
    iframe_ele = (By.XPATH, """//iframe[@id="webview"]""")
    # 白板
    green_board = (By.XPATH, """//div[@class="whiteboard-box "]""")

    # 白板功能
    # 画笔
    huabi = (By.XPATH, """//span[@class="icon iconfont iconhuabi "]""")
    # 文本
    wenben = (By.XPATH, """//span[@class="icon iconfont iconwenben "]""")
    # 直线
    zhixian = (By.XPATH, """//span[@class="icon iconfont iconxiantiao "]""")
    # 形状
    xingzhuang = (By.XPATH, """//span[@class="icon iconfont iconfangxing    "]""")
    # 移动
    yidong = (By.XPATH, """//span[@class="icon iconfont iconyidong "]""")
    # 橡皮擦
    xiangpica = (By.XPATH, """//span[@class="icon iconfont iconxiangpica "]""")
    # 文本输入框
    wenben_text = (By.XPATH, """//textarea[@class="editable-textarea my-textarea"]""")
    # 文本位置
    wenben_location = (By.XPATH, "//div[@class='textarea-container']")

    # "进入直播间"按钮         format里面的参数还是要继续修改，先创建课程，再通过课程名称来查看进入直播间按钮
    in_live_btn = (By.XPATH, """//div[text()={}]/..//button[@class="ant-btn ant-btn-primary"]""".format("测试新增直播课"))

    # 验证元素

    def __init__(self, driver):
        MainPage.__init__(self, driver)

    # 点击切换白板
    def click_white_board(self):
        self.click(self.white_board)

    # 点击添加白板
    def click_add_white_board(self):
        self.click(self.add_white_board)

    # 打开白板
    def click_open_white_board(self):
        self.click(self.open_white_board)

    # 点击画笔
    def click_huabi(self):
        self.click(self.huabi)

    # 点击文本
    def click_wenben(self):
        self.click(self.wenben)

    # 直线
    def click_line(self):
        self.click(self.zhixian)

    # 形状
    def click_block(self):
        self.click(self.xingzhuang)

    # 移动
    def click_move(self):
        self.click(self.yidong)

    # 橡皮擦
    def click_eraser(self):
        self.click(self.xiangpica)

    def input_wenben(self, text):
        self.input_text(self.wenben_text, text=text)

    def move_get_wenben(self):
        self.mouse_move(100, 100)

    def wenben_location_ele(self):
        # 不加*会报错
        return self.find_element(self.wenben_location)


