import time

import allure
import pytest

from src.pageobject.whiteboardpage import WhiteBoardPage
from src.framework.appDriver import get_app_driver

from src.framework.logger import Logger
from src.framework.common import create_a_live
from src.framework.common import screenshot_path, compare_pictures, year_to_minute
from src.framework.common import get_allure_screenshots

from config import readConfig

import sys


class TestLivePage(object):
    cloud_class_location = readConfig.test_location()
    driver = get_app_driver(cloud_class_location)
    White_Board_page = WhiteBoardPage(driver=driver)

    @pytest.fixture(scope="module", autouse=True)
    def before_test(self):
        self.logger = Logger('live page').getlog()
        time.sleep(15)
        live_course_name = create_a_live(start_time=25, start_time2=1)
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
        self.White_Board_page.sleep(15)
        self.White_Board_page.login()
        self.White_Board_page.sleep(2)
        print(live_course_name[0])
        self.White_Board_page.click_in_live_btn(live_course_name[0])
        self.White_Board_page.sleep(5)
        self.White_Board_page.change_window(self.White_Board_page.camera_btn)
        self.White_Board_page.sleep(5)

    @pytest.yield_fixture(scope="module", autouse=True)
    def after_test(self):
        yield self.driver
        self.driver.quit()

    @allure.title("测试白板功能-新增白板")
    def testAddAndOpenWhiteBoard(self):
        self.White_Board_page.click_white_board()
        self.White_Board_page.sleep(2)
        self.White_Board_page.click_add_white_board()
        self.White_Board_page.click_camera_btn()
        self.White_Board_page.sleep(1)
        before_open_white_board = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_open_white_board)
        get_allure_screenshots(before_open_white_board, "打开白板前截图")
        self.White_Board_page.click_open_white_board()
        self.White_Board_page.sleep(1)
        after_open_white_board = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_open_white_board)
        get_allure_screenshots(after_open_white_board, "打开白板后截图")
        result = compare_pictures(before_open_white_board, after_open_white_board)
        print(result)
        assert 10 < result

    @allure.title("测试白板功能-文本输入")
    def testWhiteBoardText(self):
        self.White_Board_page.sleep(1)
        self.White_Board_page.click_wenben()
        self.White_Board_page.sleep(3)
        # 切换iframe前后都要点击一次才能生效，神奇
        self.White_Board_page.move_get_wenben()
        self.White_Board_page.switch_to_iframe("webview")
        self.White_Board_page.move_get_wenben()
        # print(self.White_Board_page.ifElementExist(self.White_Board_page.wenben_text))
        self.White_Board_page.sleep(1)
        before_send_wenben = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_send_wenben)
        get_allure_screenshots(before_send_wenben, "输入文本框字符前截图")
        # 切换iframe后必须时textarea才能输入文本
        self.White_Board_page.input_wenben("11111")
        self.White_Board_page.sleep(1)
        after_send_wenben = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_send_wenben)
        get_allure_screenshots(after_send_wenben, "输入文本框字符后截图")
        result = compare_pictures(before_send_wenben, after_send_wenben)
        print(result)
        assert 10 < result

    @allure.title("测试白板功能-画笔")
    def testWhiteBoardPen(self):
        self.White_Board_page.sleep(1)
        self.White_Board_page.switch_to_current()
        self.White_Board_page.click_huabi()
        self.White_Board_page.switch_to_iframe("webview")
        before_drap_huabi = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_drap_huabi)
        get_allure_screenshots(before_drap_huabi, "点击画笔前截图")
        self.White_Board_page.sleep(1)
        self.White_Board_page.drag_mouse(self.White_Board_page.wenben_location_ele(), 200, 200)
        self.White_Board_page.sleep(1)
        after_drap_huabi = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_drap_huabi)
        get_allure_screenshots(after_drap_huabi, "点击画笔后截图")
        result = compare_pictures(before_drap_huabi, after_drap_huabi)
        print(result)
        assert 10 < result

    @allure.title("测试白板功能-直线")
    def testWhiteBoardLine(self):
        self.White_Board_page.sleep(1)
        self.White_Board_page.switch_to_current()
        self.White_Board_page.click_zhixian()
        self.White_Board_page.switch_to_iframe("webview")
        before_drap_zhixian = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_drap_zhixian)
        get_allure_screenshots(before_drap_zhixian, "点击直线前截图")
        self.White_Board_page.sleep(1)
        self.White_Board_page.drag_mouse(self.White_Board_page.wenben_location_ele(), 200, 200)
        self.White_Board_page.sleep(1)
        after_drap_zhixian = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_drap_zhixian)
        get_allure_screenshots(after_drap_zhixian, "点击直线后截图")
        result = compare_pictures(before_drap_zhixian, after_drap_zhixian)
        print(result)
        assert 10 < result

    @allure.title("测试白板功能-形状")
    def testWhiteBoardBlock(self):
        self.White_Board_page.sleep(1)
        self.White_Board_page.switch_to_current()
        self.White_Board_page.click_block()
        self.White_Board_page.switch_to_iframe("webview")
        before_drap_xingzhuang = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_drap_xingzhuang)
        get_allure_screenshots(before_drap_xingzhuang, "点击形状前截图")
        self.White_Board_page.sleep(1)
        self.White_Board_page.drag_mouse(self.White_Board_page.wenben_location_ele(), 200, 200)
        self.White_Board_page.sleep(1)
        after_drap_xingzhuang = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_drap_xingzhuang)
        get_allure_screenshots(after_drap_xingzhuang, "点击形状后截图")
        result = compare_pictures(before_drap_xingzhuang, after_drap_xingzhuang)
        print(result)
        assert 10 < result

    @allure.title("测试白板功能-移动")
    def testWhiteBoardMove(self):
        self.White_Board_page.sleep(1)
        self.White_Board_page.switch_to_current()
        self.White_Board_page.click_move()
        self.White_Board_page.switch_to_iframe("webview")
        before_drap_yidong = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_drap_yidong)
        get_allure_screenshots(before_drap_yidong, "点击移动前截图")
        self.White_Board_page.sleep(1)
        self.White_Board_page.drag_mouse(self.White_Board_page.wenben_location_ele(), 200, 200)
        self.White_Board_page.sleep(1)
        after_drap_yidong = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_drap_yidong)
        get_allure_screenshots(after_drap_yidong, "点击移动后截图")
        result = compare_pictures(before_drap_yidong, after_drap_yidong)
        print(result)
        assert 10 < result

    @allure.title("测试白板功能-橡皮擦")
    def testWhiteBoardBlock(self):
        self.White_Board_page.sleep(1)
        self.White_Board_page.switch_to_current()
        self.White_Board_page.click_eraser()
        self.White_Board_page.switch_to_iframe("webview")
        before_drap_xiangpica = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_drap_xiangpica)
        get_allure_screenshots(before_drap_xiangpica, "点击橡皮擦前截图")
        self.White_Board_page.sleep(1)
        self.White_Board_page.drag_mouse(self.White_Board_page.wenben_location_ele(), 200, 200)
        self.White_Board_page.sleep(1)
        after_drap_xiangpica = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_drap_xiangpica)
        get_allure_screenshots(after_drap_xiangpica, "点击橡皮擦后截图")
        result = compare_pictures(before_drap_xiangpica, after_drap_xiangpica)
        print(result)
        assert 10 < result


if __name__ == '__main__':
    pytest.main(["-v"])
