from src.pageobject.loginpage import LoginPage
from src.framework.logger import Logger
from config import readConfig
from commom.appDriver import get_app_driver

import unittest


class TestLoginPage(unittest.TestCase):
    logger = Logger('login page').getlog()
    account = readConfig.test_account()
    password = readConfig.test_password()
    cloud_class_location = readConfig.test_location()

    def setUp(self) -> None:
        print(11111)
        # 指定chrome的webdriver路径
        self.driver = get_app_driver(self.cloud_class_location)

    def tearDown(self) -> None:
        self.driver.quit()

    # 测试登录
    def testLogin(self):
        driver = self.driver
        login_page = LoginPage(driver=driver)
        login_page.click_phone_login()
        login_page.input_account(account=self.account)
        login_page.input_password(password=self.password)
        login_page.click_login()
        login_page.sleep(1)
        self.assertTrue(login_page.ifElementExist(login_page.store_name))


if __name__ == '__main__':
    unittest.main(verbosity=1)
