import allure
import pytest

from src.pageobject.loginpage import LoginPage
from src.framework.logger import Logger
from src.framework.appDriver import get_app_driver
from src.framework.common import get_token
from config import readConfig


class TestLoginPage(object):
    @pytest.fixture(scope="function")
    def before_test_case(self):
        self.user = "lgw-b"
        self.logger = Logger('login page').getlog()
        self.account = readConfig.test_header(self.user)['username']
        self.password = readConfig.test_header(self.user)['password']
        self.enterpriseId = readConfig.test_header(self.user)['enterpriseId']
        cloud_class_location = readConfig.test_location()
        self.env = readConfig.get_env()
        self.get_localStorage = get_token(self.user)
        # 指定客户端的本地路径,在/config/config.ini配置
        self.driver = get_app_driver(cloud_class_location)
        yield self.driver
        self.driver.quit()

    @allure.title("测试登录")
    @pytest.mark.usefixtures("before_test_case")
    def testLogin(self):
        login_page = LoginPage(driver=self.driver)
        login_page.sleep(1)
        # 执行脚本，隐藏的手机号码输入框弹出
        # login_page.phone_input_execute_script()
        login_page.excute_script_set_token("xmykt-client_token", self.get_localStorage['xmToken'])
        login_page.excute_script_set_token("xmykt-client_enterpriseId", self.enterpriseId)
        login_page.excute_script_set_token("xmykt-client_userId", self.get_localStorage['userId'])
        login_page.excute_script_set_url()
        login_page.sleep(1)

        # login_page.refresh()
        # login_page.click_phone_login()
        # login_page.input_account(account=self.account)
        # login_page.input_password(password=self.password)
        # login_page.get_env_window()
        # login_page.click_what('span', 'text()', self.env)
        # login_page.click_close_env_window()
        # login_page.click_login()
        # login_page.click_text("取 消")
        # 校验是否存在店铺名称的元素
        assert login_page.ifElementExist(login_page.store_name)


if __name__ == '__main__':
    pytest.main(["-v"])
