import time

import allure
import pytest

from src.framework.logger import Logger
from src.pageobject.mainpage import MainPage
from src.framework.common import create_a_live
from src.framework.appDriver import get_app_driver

from config import readConfig


class TestMainPage(object):
    @pytest.fixture(scope="module", autouse=True)
    def before_test(self):
        print("before_test")
        self.logger = Logger('main page').getlog()
        self.cloud_class_location = readConfig.test_location()
        self.live_course_name = create_a_live(start_time=25, start_time2=1)
        time.sleep(15)
        return self.cloud_class_location, self.live_course_name

    @pytest.fixture(scope="function", autouse=True)
    def before_test_case(self, before_test):
        print("before_test_case")
        # 指定客户端的本地路径,在/config/config.ini配置
        self.cloud_class_location = before_test[0]
        self.live_course_name = before_test[1]
        self.sleep_time = 2
        self.driver = get_app_driver(self.cloud_class_location)
        self.main_page = MainPage(driver=self.driver)
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
        self.main_page.login()
        yield self.driver
        self.driver.quit()

    @allure.title("测试主页-进入未开启直播")
    @pytest.mark.run(order=1)
    def test_UnStartLive(self):
        self.main_page.sleep(self.sleep_time)
        self.main_page.page_down(self.live_course_name[0])
        self.main_page.sleep(self.sleep_time)
        self.main_page.click_in_live_btn(self.live_course_name[0])
        self.main_page.sleep(self.sleep_time)
        self.main_page.change_window(self.main_page.camera_btn)
        self.main_page.sleep(self.sleep_time)
        assert self.main_page.ifElementExist(self.main_page.camera_btn)
        self.main_page.sleep(self.sleep_time)

    @allure.step("第一步：进入直播间")
    def enter_start_live(self):
        print(self.live_course_name)
        self.main_page.sleep(60)
        self.main_page.page_down(self.live_course_name[1])
        self.main_page.sleep(self.sleep_time)
        self.main_page.click_in_live_btn(self.live_course_name[1])
        self.main_page.sleep(self.sleep_time)

    @allure.step("第二步：二次确认开启直播")
    def twice_start_live(self):
        self.main_page.change_window(self.main_page.start_live_btn)
        self.main_page.start_live()
        self.main_page.sleep(self.sleep_time)

    @allure.step("第三步：关闭直播")
    def close_live(self):
        self.main_page.change_window(self.main_page.camera_btn)
        self.main_page.stop_live()
        self.main_page.sleep(self.sleep_time)
        self.main_page.change_window(self.main_page.cancel_stop_live_btn)

    @allure.step("第四步：确认结束直播")
    def end_live(self):
        self.main_page.sleep(self.sleep_time)
        self.main_page.stop_live()
        self.main_page.sleep(self.sleep_time)
        self.main_page.change_window(self.main_page.live_list)
        assert "查看回放" == self.main_page.get_btn_text(self.live_course_name[1])
        self.main_page.sleep(self.sleep_time)

    # @pytest.mark.skip()
    @allure.title("测试主页-进入已开启直播")
    @pytest.mark.run(order=2)
    def test_StartLive(self):
        self.enter_start_live()
        self.twice_start_live()
        self.close_live()
        self.end_live()

    @pytest.mark.skip()
    @pytest.mark.run(order=3)
    @allure.title("测试回放")
    def test_ReviewLive(self):
        print(self.live_course_name)
        self.main_page.sleep(self.sleep_time)
        self.main_page.page_down(self.live_course_name[1])
        self.main_page.sleep(self.sleep_time)
        self.main_page.click_review_live_btn(self.live_course_name[1])
        self.main_page.sleep(self.sleep_time)


if __name__ == '__main__':
    pytest.main(["-v"])
