import time

import pytest

from src.framework.logger import Logger
from src.pageobject.whiteboardpage import WhiteBoardPage
from src.framework.common import create_a_live
from src.framework.appDriver import get_app_driver
from src.framework.common import screenshot_path, compare_pictures, year_to_minute

from config import readConfig

import sys


class TestLivePage(object):
    logger = Logger('live page').getlog()
    cloud_class_location = readConfig.test_location()
    time.sleep(15)
    live_course_name = create_a_live(start_time=25, start_time2=1)
    driver = get_app_driver(cloud_class_location)
    White_Board_page = WhiteBoardPage(driver=driver)
    # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
    White_Board_page.sleep(15)
    White_Board_page.login()
    White_Board_page.sleep(2)
    White_Board_page.click_in_live_btn(live_course_name[0])
    White_Board_page.sleep(5)
    White_Board_page.change_window(White_Board_page.camera_btn)
    White_Board_page.sleep(5)

    def setup_class(self):
        # 指定客户端的本地路径,在/config/config.ini配置
        pass

    def teardown_class(self):
        self.driver.quit()

    # 测试白板功能-文本输入
    def testWhiteBoard(self):
        self.White_Board_page.click_white_board()
        self.White_Board_page.sleep(2)
        self.White_Board_page.click_add_white_board()
        self.White_Board_page.click_camera_btn()
        self.White_Board_page.sleep(1)
        self.White_Board_page.click_open_white_board()

        self.White_Board_page.click_wenben()
        self.White_Board_page.sleep(3)
        # 切换iframe前后都要点击一次才能生效，神奇
        self.White_Board_page.move_get_wenben()
        self.White_Board_page.switch_to_iframe("webview")
        self.White_Board_page.move_get_wenben()
        print(self.White_Board_page.ifElementExist(self.White_Board_page.wenben_text))
        self.White_Board_page.sleep(1)
        before_send_wenben = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(before_send_wenben)
        # 切换iframe后必须时textarea才能输入文本
        self.White_Board_page.input_wenben("11111")
        self.White_Board_page.sleep(1)
        after_send_wenben = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.White_Board_page.save_screenshot(after_send_wenben)
        wenben_result = compare_pictures(before_send_wenben, after_send_wenben)
        print(wenben_result)
        assert 10 < wenben_result


if __name__ == '__main__':
    pytest.main(["-v"])
