from src.pageobject.mainpage import MainPage
from selenium.webdriver.common.by import By

# 直播页面-讨论区操作
class LiveDiscussPage(MainPage):
    # 元素集

    # 讨论tab
    discuss_tab = (By.XPATH, """//div[@class='sectionTab']/div[text()="讨论"]""")
    # 讨论文字输入框
    discuss_box = (By.XPATH, "//div[@class='textBox']/textarea")
    # 发送按钮
    discuss_submit_btn = (By.XPATH, """//div/button/span[text()="发 送"]""")
    # 学员未禁言
    discuss_forbid = (By.XPATH, "//div/label[@class='ant-checkbox-wrapper']")
    # 学员已禁言
    discuss_forbided = (By.XPATH, "//div/label[@class='ant-checkbox-wrapper ant-checkbox-wrapper-checked']/span")
    # 讨论文字显示区
    message_box = (By.XPATH, """//div[@class='messageBox mine']//div[text()="discuss"]""")

    def __init__(self, driver):
        MainPage.__init__(self, driver)

    # 点击讨论tab
    def click_discuss_tab(self):
        self.click(self.discuss_tab)

    # 点击讨论内容输入框
    def click_discuss_box(self):
        self.click(self.discuss_box)

    # 输入讨论文字
    def input_discuss_word(self):
        self.input_text(self.discuss_box, "discuss")

    # 点击发送讨论文字
    def click_discuss_submit_btn(self):
        self.click(self.discuss_submit_btn)

    # 点击全员禁言
    def click_discuss_forbid(self):
        self.click(self.discuss_forbid)

    # 点击取消全员禁言
    def click_discuss_forbided(self):
        self.click(self.discuss_forbided)


