import time

import pytest

from src.framework.logger import Logger
from src.pageobject.livepage import LivePage
from src.framework.common import create_a_live
from src.framework.appDriver import get_app_driver
from src.framework.common import screenshot_path, compare_pictures, year_to_minute

from config import readConfig

import sys


class TestLivePage(object):
    logger = Logger('live page').getlog()
    cloud_class_location = readConfig.test_location()
    time.sleep(15)
    live_course_name = create_a_live(start_time=25, start_time2=1)
    # 指定客户端的本地路径,在/config/config.ini配置
    driver = get_app_driver(cloud_class_location)
    live_page = LivePage(driver=driver)
    # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
    live_page.sleep(15)
    live_page.login()
    live_page.sleep(2)
    live_page.click_in_live_btn(live_course_name[0])
    live_page.sleep(5)
    live_page.change_window(live_page.camera_btn)
    live_page.sleep(5)

    def setup_class(self):
        pass

    def teardown_class(self):
        self.driver.quit()

    # 测试直播间摄像头  测试的时候如果摄像头黑屏，检查一下是否开了两个客户端，造成了摄像头抢占
    def testLiveCamera(self):
        before_savescreen = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.live_page.save_screenshot(before_savescreen)
        self.live_page.click_camera_btn()
        self.live_page.sleep(1)
        after_savescreen = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.live_page.save_screenshot(after_savescreen)
        result = compare_pictures(before_savescreen, after_savescreen)
        assert 10 < result
        self.live_page.sleep(3)

    # 测试添加白板并打开
    def testWhiteBoard(self):
        self.live_page.click_white_board()
        self.live_page.sleep(2)
        self.live_page.click_add_white_board()
        self.live_page.click_camera_btn()
        self.live_page.sleep(1)
        before_whiteboard_savescreen = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.live_page.save_screenshot(before_whiteboard_savescreen)
        self.live_page.click_open_white_board()
        self.live_page.sleep(1)
        after_whiteboard_savescreen = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.live_page.save_screenshot(after_whiteboard_savescreen)
        whiteboard_result = compare_pictures(before_whiteboard_savescreen, after_whiteboard_savescreen)
        assert 10 < whiteboard_result


if __name__ == '__main__':
    pytest.main(["-v"])
