import time

import pytest

from src.framework.logger import Logger
from src.pageobject.mainpage import MainPage
from src.framework.common import create_a_live
from src.framework.appDriver import get_app_driver

from config import readConfig


class TestMainPage(object):
    logger = Logger('main page').getlog()
    cloud_class_location = readConfig.test_location()
    time.sleep(15)
    live_course_name = create_a_live(start_time=25, start_time2=1)

    def setup_method(self):
        # 指定客户端的本地路径,在/config/config.ini配置
        self.driver = get_app_driver(self.cloud_class_location)

    def teardown_method(self):
        self.driver.quit()

    # 测试主页-进入未开启直播
    def test_1_UnStartLive(self):
        driver = self.driver
        main_page = MainPage(driver=driver)
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
        main_page.sleep(15)
        main_page.login()
        main_page.sleep(2)
        main_page.page_down(self.live_course_name[0])
        main_page.sleep(1)
        main_page.click_in_live_btn(self.live_course_name[0])
        main_page.sleep(5)
        main_page.change_window(main_page.camera_btn)
        main_page.sleep(2)
        assert main_page.ifElementExist(main_page.camera_btn)
        main_page.sleep(3)

    # 测试主页-进入已开启直播
    def test_2_StartLive(self):
        driver = self.driver
        main_page = MainPage(driver=driver)
        print(self.live_course_name)
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
        main_page.sleep(15)
        main_page.login()
        main_page.sleep(60)
        main_page.page_down(self.live_course_name[1])
        main_page.sleep(3)
        main_page.click_in_live_btn(self.live_course_name[1])
        main_page.sleep(5)
        # 二次确认开启直播
        main_page.change_window(main_page.start_live_btn)
        main_page.start_live()
        main_page.sleep(5)
        # 关闭直播
        main_page.change_window(main_page.camera_btn)
        main_page.stop_live()
        main_page.sleep(5)
        main_page.change_window(main_page.cancel_stop_live_btn)
        # 确认结束直播
        main_page.stop_live()
        main_page.sleep(3)
        main_page.change_window(main_page.live_list)
        assert "查看回放" == main_page.get_btn_text(self.live_course_name[1])
        main_page.sleep(3)

    # 测试回放
    def test_3_ReviewLive(self):
        driver = self.driver
        main_page = MainPage(driver=driver)
        print(self.live_course_name)
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
        main_page.sleep(15)
        main_page.login()
        main_page.sleep(5)
        main_page.page_down(self.live_course_name[1])
        main_page.sleep(1)
        main_page.click_in_live_btn(self.live_course_name[1])
        main_page.sleep(5)


if __name__ == '__main__':
    pytest.main(["-v"])
