from src.pageobject.basepage import Page
from selenium.webdriver.common.by import By


# 主页面-时间bar
class MainBarPage(Page):
    # 元素集

    # 未选择的日期
    day_unselected = (By.XPATH, "//div[@class='day']")
    # 已被选择的日期-星期
    day_selected_week = (By.XPATH, "//div[@class='day selected']/p[1]")
    # 已被选择的日期-月份日期
    day_selected_month = (By.XPATH, "//div[@class='day selected']/p[2]")
    # 上周
    last_week = (By.XPATH, "//div[@class='calendar_Time_week']/div[1]/span[@class='icon iconfont']")
    # 下周
    next_week = (By.XPATH, "//div[@class='calendar_Time_week']/div[3]/span[@class='icon iconfont']")

    def __init__(self, driver):
        Page.__init__(self, driver)

    # 获取选择日期的星期几
    def week_day_text(self):
        return self.get_text(self.day_selected_week)

    # 获取选择日期的月份-日期
    def month_day_text(self):
        return self.get_text(self.day_selected_month)

    # 点击相邻日期
    def click_other_day(self):
        self.click(self.day_unselected)

    # 点击上周
    def click_last_week(self):
        self.click(self.last_week)

    # 点击下周
    def click_next_week(self):
        self.click(self.next_week)
